L              [0-9a-f]
H              ({L}{1,2})

    #include "../../config.h"
    #include <sys/types.h>
    #include <sys/socket.h>

    #include <net/if.h>
    #if HAVE_NETINET_IN_H
    #include <netinet/in.h>
    #endif
    #if HAVE_NET_ETHERNET_H
    #include <net/ethernet.h>
    #endif
    #if HAVE_NETINET_ETHER_H
    #include <netinet/ether.h>
    #endif
    #if HAVE_NETINET_IF_ETHER_H
    #include <netinet/if_ether.h>
    #endif

    #include <arpa/nameser.h>
    #include <arpa/inet.h>

    #include <ctype.h>
    #include <netdb.h>
    #include <resolv.h>
    #include <stdio.h>
    #include <string.h>
    #include <unistd.h>

    #include "gnuc.h"
    #ifdef HAVE_OS_PROTO_H
    #include "os-proto.h"
    #endif

    #undef yywrap
    #ifdef FLEX_SCANNER
    #define YY_NO_UNPUT
    #endif
    #define convert(str) (fputs(ether2host(str), stdout))
    char *ether2host(char *);
    int yywrap(void);
    int yylex(void);
%%

{H}:{H}:{H}:{H}:{H}:{H}	convert(yytext);

({H}:){1,5}		ECHO;		/* anti-backtrack */
{H}((:{H}){1,4})	ECHO;		/* anti-backtrack */

{L}+			ECHO;
[^0-9a-z\n]+		ECHO;
[^0-9a-z\n]+\n		ECHO;

%%

/*
 * Copyright (c) 1990, 1991, 1996, 1999, 2000, 2004
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char copyright[] =
    "@(#) Copyright (c) 1990, 1991, 1996, 1999, 2000, 2004\n\
The Regents of the University of California.  All rights reserved.\n";
static const char rcsid[] =
    "@(#) $Id: ef.l,v 1.2 2005/09/02 23:00:06 vern Exp $ (LBL)";
#endif

#define HSIZE 1024		/* must be a power of two */

struct htable {
	u_int high;
	u_short low;
	char *name;
	struct htable *next;
} htable[HSIZE];

#ifdef DEBUG
int debug = 0;
#endif

int targc;
char **targv;

extern char *optarg;
extern int optind, opterr;

/* Forwards */
#ifdef DEBUG
void dump(void);
#endif
int main(int, char **);

int
main(argc, argv)
	int argc;
	char **argv;
{
	register char *cp;
	register int op;
	char *argv0;

	if ((cp = strrchr(argv[0], '/')) != NULL)
		argv0 = cp + 1;
	else
		argv0 = argv[0];

	opterr = 0;
	while ((op = getopt(argc, argv, "d")) != EOF)
		switch (op) {

#ifdef DEBUG
		case 'd':
			++debug;
			break;
#endif

		default:
			(void)fprintf(stderr, "usage: %s [-d] [file ...]\n",
			    argv0);
			exit(1);
			/* NOTREACHED */
		}

	/* Let yywrap() figure out if there are any arguments to open */
	targc = argc - optind;
	targv = &argv[optind];
	yyin = 0;
	(void)yywrap();

	/* Process file opened by yywrap() or stdin if no arguments */
	if (yyin)
		yylex();
#ifdef DEBUG
	if (debug) {
		fflush(stdout);
		dump();
	}
#endif
	exit(0);
}

int
yywrap()
{
	register char *file;
	static int didany = 0;

	/* Close file, if necessary */
	if (yyin && yyin != stdin) {
		(void)fclose(yyin);
		yyin = 0;
	}

	/* Spin through arguments until we run out or successfully open one */
	while (targc > 0) {
		file = targv[0];
		--targc;
		++targv;
		++didany;
		if ((yyin = fopen(file, "r")) != NULL)
			return(0);
		else
			perror(file);
	}
	if (!didany)
		yyin = stdin;
	return(1);
}

char *
ether2host(str)
	char *str;
{
	register u_int high;
	register u_short low, ehash;
	register char *cp;
	register u_char *ether;
	register struct htable *p, *p2;
	char buf[512];

	if ((ether = (u_char *)ether_aton(str)) == 0)
		return(0);

	high = *(u_int *)&ether[0];
	low = *(u_short *)&ether[4];
	ehash = high >> 16;
	ehash ^= high ^ low;

	/* First check if we already know about it */
	for (p = &htable[ehash & (HSIZE - 1)]; p; p = p->next)
		if (p->high == high && p->low == low && p->name)
			return (p->name);

	if (ether_ntohost(buf, (struct ether_addr *)ether))
		strcpy(buf, str);

	/* Malloc space for new name */
	cp = malloc((u_int) strlen(buf) + 1);
	if (cp == 0)
		return(str);

	/* add to hash table */
	p = &htable[ehash & (HSIZE - 1)];
	if (p->name) {
		/* Handle the collision */
		p2 = (struct htable *)malloc(sizeof(struct htable));
		if (p2 == 0) {
			/* Lose, lose */
			free(cp);
			return(str);
		}
		memset((char *)p2, 0, sizeof(struct htable));
		p2->next = p->next;
		p->next = p2;
		p = p2;
	}

	/* Install new host */
	p->high = high;
	p->low = low;
	p->name = strcpy(cp, buf);

	/* Return answer */
	return(p->name);
}

#ifdef DEBUG
void
dump()
{
	register int i, j, n, d;
	register struct htable *p, *p2;

	d = n = 0;
	for (p = htable, i = 0; i < HSIZE; ++p, ++i)
		if (p->name) {
			++n;
			j = 0;
			for (p2 = p; p2; p2 = p2->next) {
				(void)fprintf(stderr,
				    "%4d:%d 0x%08x%04x \"%s\"\n", i, j,
				    p2->high, p2->low,
				    p2->name ? p2->name : "<nil>");
				++d;
				++j;
			}
		}
	d -= n;
	(void)fprintf(stderr, "%d entries (%d dynamically linked)\n", n, d);
}
#endif
