# $Id: brolite.bro,v 1.19 2005/03/20 06:51:11 vern Exp $

# Bro Lite base configuration file.

# General policy - these scripts are more infrastructural than service
# oriented, so in general avoid changing anything here.

@load site	# defines local and neighbor networks from static config
@load alarm	# open logging file for alarm events
@load tcp	# initialize BPF filter for SYN/FIN/RST TCP packets
@load weird	# initialize generic mechanism for unusual events
@load conn	# access and record connection events
@load hot	# defines certain forms of sensitive access
@load frag	# process TCP fragments
@load print-resources	# on exit, print resource usage information

# Scan detection policy.
@load scan	# generic scan detection mechanism
@load trw	# additional, more sensitive scan detection
#@load drop	# include if installation has ability to drop hostile remotes

# Application level policy - these scripts operate on the specific service.
@load http	# general http analyzer, low level of detail
@load http-request	# detailed analysis of http requests
@load http-reply	# detailed analysis of http reply's 

# Track software versions; required for some signature matching.  Also
# can be used by http and ftp policies.
@load software

@load ftp	# FTP analysis
@load portmapper	# record and analyze RPC portmapper requests
@load smtp	# record and analyze email traffic
@load tftp	# identify and log TFTP sessions
@load login     # rlogin/telnet analyzer
@load blaster   # blaster worm detection
@load stepping  # "stepping stone" detection
@load synflood  # synflood attacks detection
#@load icmp	# icmp analysis - expensive!

# Tuning of memory consumption.
@load reduce-memory	# set timers to not hold on to data for as long
@load inactivity	# time out connections for certain services more quickly
# @load print-globals	# on exit, print the size of global script variables

# The following would be used to enable state to be transferred across
# checkpoints.  Currently not implemented.
#@load listen-clear
#@load hand-over
#@load remote

# Record system statistics to the notice file
@load stats

# udp analysis - potentially expensive, depending on a site's traffic profile
#@load udp.all
#@load remove-multicast

# Prints the pcap filter and immediately exits.  Not used during
# normal operation.
#@load print-filter

## End policy script loading.


## Basic configuration.

# Remove these notices from logging since they can be too noisy.
redef notice_action_filters += {
	[[ContentGap, AckAboveHole]] = ignore_notice,
};

# Send these only to the notice log, not to the alarm file.
redef notice_action_filters += {
	[[AddressDropIgnored, DroppedPackets, 
	ResourceSummary, W32B_SourceRemote,
	WeirdActivity, TRW::TRWScanSummary,
	RetransmissionInconsistency]] = file_notice,
};

# Time to hold onto fragmented packets.  If this is not defined,
# they will be held forever.  It makes sense for the value here
# to be matched to that of non_analyzed_lifetime (reduce-memory).
redef frag_timeout = 120 secs;

# Set additional policy prefixes.
@prefixes += lite

# Adjust max_timers_expire back to default value (reduce-memory
# turns off this variable).
redef max_timer_expires = 32;

## End basic configuration.


## Scan configuration.
@ifdef ( shut_down_all_scans )
	# This variable is misnamed.  It should "analyze all services
	# for scans".
	redef shut_down_all_scans = T;

	# The following turns off scan detection.
	#redef suppress_scan_checks = T;

	# Be a bit more aggressive than default (though the defaults
	# themselves should be fixed).
	redef report_outbound_peer_scan = { 100, 1000, };

	# These services are skipped for scan detection due to excessive
	# background noise.
	redef skip_services += {
		http,           # avoid Code Red etc. overload
		27374/tcp,      # massive scanning in Jan 2002
		1214/tcp,       # KaZaa scans
		12345/tcp,      # massive scanning in Apr 2002
		445/tcp,        # massive distributed scanning Oct 2002

		135/tcp,        # these days, NetBIOS scanning is endemic
		137/udp,
		139/tcp,
		1025/tcp,

		6129/tcp,       # Dameware
		3127/tcp,       # MyDoom worms worms worms!
		2745/tcp,       # Bagel worm
		1433/tcp,       # Distributed scanning, April 2004
		5000/tcp,       # Distributed scanning, May 2004
		5554/tcp,       # More worm food, May 2004
		9898/tcp,       # Worms attacking worms. ugh - May 2004
		3410/tcp,       # More worm food, June 2004
		3140/tcp,       # Dyslexic worm food, June 2004
		27347/tcp,      # Can't kids type anymore?
		1023/tcp,       # Massive scanning, July 2004
		17300/tcp,      # Massive scanning, July 2004
	};

@endif

@ifdef ( ICMP::detect_scans )
	# Whether to detect ICMP scans.
	redef ICMP::detect_scans = F;
	redef ICMP::scan_threshold = 100;
@endif

	# remove logging TRW scan events
	redef notice_action_filters += {
		[TRW::TRWAddressScan] = ignore_notice,
	};

## End scan configuration.


# The following is used to transfer state between Bro's when one
# takes over from another.
#
# NOTE: not implemented in the production version, so ignored for now.
@ifdef ( remote_peers_clear )
	redef remote_peers_clear += {
		[127.0.0.1, 55555/tcp] = [$hand_over = T],
		[127.0.0.1, 0/tcp] = [$hand_over = T]
	};
@endif

# By default, try to reduce memory usage even more beyond loading
# reduce_memory.  This will cause Bro to maintain less state, and will
# possibly miss some alarms.  Remove these if memory usage at your site
# does not appear to be an issue.

redef partial_connection_ok = T;
redef non_analyzed_lifetime = 0 secs;

redef tcp_SYN_timeout = 12 secs;
redef tcp_attempt_delay = 15 secs;

redef tcp_inactivity_timeout = 5 mins;
redef udp_inactivity_timeout = 60 secs;
redef icmp_inactivity_timeout = 60 secs;

# use tagged log files for alarms and notices
redef use_tagging = T;

# set Max file size to 250 MB
redef log_max_size = 250e6 ;

