# $Id: dns-info.bro,v 1.3 2004/09/16 20:15:58 rwinslow Exp $

# Types, errors, and fields for analyzing DNS data.  A helper file
# for dns.bro.

const PTR = 12;
const EDNS = 41;
const ANY = 255;

const query_types = {
	[1] = "A", [2] = "NS", [5] = "CNAME", [6] = "SOA",
	[11] = "WKS", [PTR] = "PTR", [13] = "HINFO", [15] = "MX",
	[16] = "TXT", [28] = "AAAA", [33] = "SRV", [EDNS] = "EDNS",
	[38] = "A6", [252] = "AXFR",
	[ANY] = "*",
} &default = function(n: count): string { return fmt("query-%d", n); };

const DNS_code_types = {
	[0] = "X0",
	[1] = "Xfmt",
	[2] = "Xsrv",
	[3] = "Xnam",
	[4] = "Ximp",
	[5] = "X[",
} &default = function(n: count): string { return "?"; };

# this is used for non-tsig/edns types
const base_error = {
	[0] = "NOERROR", 	# No Error
	[1] = "FORMERR", 	# Format Error
	[2] = "SERVFAIL",	# Server Failure
	[3] = "NXDOMAIN",	# Non-Existent Domain
	[4] = "NOTIMP",  	# Not Implemented
	[5] = "REFUSED", 	# Query Refused
	[6] = "YXDOMAIN",	# Name Exists when it should not
	[7] = "YXRRSET", 	# RR Set Exists when it should not
	[8] = "NXRRSet", 	# RR Set that should exist does not
	[9] = "NOTAUTH", 	# Server Not Authoritative for zone
	[10] = "NOTZONE",	# Name not contained in zone
	[11] = "unassigned-11", # available for assignment
	[12] = "unassigned-12", # available for assignment
	[13] = "unassigned-13", # available for assignment
	[14] = "unassigned-14", # available for assignment
	[15] = "unassigned-15", # available for assignment
	[16] = "BADVERS",	# for EDNS, collision w/ TSIG
	[17] = "BADKEY",	# Key not recognized
	[18] = "BADTIME",	# Signature out of time window
	[19] = "BADMODE",	# Bad TKEY Mode
	[20] = "BADNAME",	# Duplicate key name
	[21] = "BADALG",	# Algorithm not supported
	[3842] = "BADSIG",	# 16 <= number collision with EDNS(16);
				# this is a translation from TSIG(16)
} &default = function(n: count): string { return "?"; };

# this decyphers edns Z field values
const edns_zfield = {
	[0] = "NOVALUE",	# regular entry
	[1] = "RESERVED",
	[2] = "RESERVED",
	[4] = "RESERVED",
	[8] = "RESERVED",
	[16] = "RESERVED",
	[32] = "RESERVED",
	[64] = "RESERVED",
	[128] = "DNS_SEC_OK",	# accepts DNS Sec RRs
} &default = function(n: count): string { return "?"; };

const dns_class = {
	[1] = "C_INTERNET",
	[2] = "C_CSNET",
	[3] = "C_CHAOS",
	[4] = "C_HESOD",
	[254] = "C_NONE",
	[255] =	"C_ANY",
} &default = function(n: count): string { return "?"; };
