# $Id: ident.bro,v 1.2 2004/09/09 06:38:26 vern Exp $

@load notice
@load active
@load hot-ids

redef enum Notice += {
	IdentSensitiveID,	# sensitive username in Ident lookup
};

redef capture_filters += { ["ident"] = "tcp port 113" };

global hot_ident_ids = { always_hot_ids, } &redef;
global hot_ident_exceptions = { "uucp", "nuucp", "daemon", } &redef;

global pending_ident_requests: set[addr, port, addr, port, port, port];

event ident_request(c: connection, lport: port, rport: port)
	{
	local id = c$id;
	add pending_ident_requests[id$orig_h, id$orig_p, id$resp_h, id$resp_p, lport, rport];
	}

function add_ident_tag(c: connection, lport: port, rport: port, tag: string)
: connection
	{
	local id = c$id;
	if ( [id$orig_h, id$orig_p, id$resp_h, id$resp_p, lport, rport] in
	     pending_ident_requests )
		delete pending_ident_requests[id$orig_h, id$orig_p, id$resp_h, id$resp_p, lport, rport];
	else
		tag = fmt("orphan-%s", tag);

	local c_orig_id = [$orig_h = id$resp_h, $orig_p = rport,
				$resp_h = id$orig_h, $resp_p = lport];
	local c_orig = c_orig_id in active_conn ?  active_conn[c_orig_id] : c;

	append_addl(c_orig, tag);

	return c_orig;
	}

event ident_reply(c: connection, lport: port, rport: port,
		user_id: string, system: string)
	{
	local c_orig = add_ident_tag(c, lport, rport, fmt("ident/%s", user_id));

	if ( user_id in hot_ident_ids && user_id !in hot_ident_exceptions )
		{
		++c_orig$hot;
		NOTICE([$note=IdentSensitiveID, $conn=c,
			$msg=fmt("%s hot ident: %s",
				$user=c_orig$addl,
				id_string(c_orig$id), c_orig$addl)]);
		}
	}

event ident_error(c: connection, lport: port, rport: port, line: string)
	{
	add_ident_tag(c, lport, rport, fmt("iderr/%s", line));
	}
