# $Id: ntp.bro,v 1.2 2005/03/17 09:18:28 vern Exp $

@load udp-common

redef capture_filters += { ["ntp"] = "udp port 123" };

const excessive_ntp_request = 48 &redef;
const allow_excessive_ntp_requests: set[addr] &redef;

const ntp_code: table[count] of string = {
	[0] = "unspec",
	[1] = "sym_act",
	[2] = "sym_psv",
	[3] = "client",
	[4] = "server",
	[5] = "bcast",
	[6] = "rsv1",
	[7] = "rsv2",
};

event ntp_message(u: connection, msg: ntp_msg, excess: string)
	{
	local id = u$id;

	if ( id !in udp_rep_count && id !in udp_req_count )
		{
		check_hot(u, CONN_ATTEMPTED);
		check_scan(u, F, F);
		}

	if ( msg$code == 4 )
		# "server"
		++udp_rep_count[id];
	else
		# anything else
		++udp_req_count[id];

	local n_excess = byte_len(excess);
	if ( n_excess > excessive_ntp_request &&
	     id$orig_h !in allow_excessive_ntp_requests )
		{
		append_addl_marker(u, fmt("%s", n_excess), ",");
		++u$hot;
		}
	}
