# $Id: print-resources.bro,v 1.4 2004/12/13 07:40:10 vern Exp $

# Logs Bro resource usage information upon termination.

redef enum Notice += {
	ResourceSummary,        # Notice stype for this event
};
 
event bro_done()
	{
	local res = resource_usage();
	
	NOTICE([$note=ResourceSummary,
		$msg=fmt("elapsed time = %s, total CPU = %s, maximum memory = %d KB, peak connections = %d, peak timers = %d, peak fragments = %d",
		res$real_time, res$user_time + res$system_time,
		res$mem / 1024,
		res$max_TCP_conns + res$max_UDP_conns + res$max_ICMP_conns,
		res$max_timers, res$max_fragments)]);
	}
