@load stepping

redef capture_filters += { ["ssh-stepping"] = "tcp port 22" };

event connection_established(c: connection)
	{
	if ( c$id$resp_p == ssh )
		# No point recording these, and they're potentially huge
		# due to use of ssh for file transfers.
		set_record_packets(c$id, F);
	}

event partial_connection(c: connection)
	{
	if ( c$id$orig_p == ssh || c$id$resp_p == ssh )
		# No point recording these, and they're potentially huge
		# due to use of ssh for file transfers.
		set_record_packets(c$id, F);
	}
