# $Id: ssh.bro,v 1.1.1.1 2004/04/30 00:31:28 jason Exp $

redef capture_filters += { ["ssh"] = "tcp port 22" };

global ssh_log = open_log_file("ssh") &redef;

# Indexed by address and T for client, F for server.
global did_ssh_version: table[addr, bool] of count &default = 0;

event ssh_client_version(c: connection, version: string)
	{
	if ( ++did_ssh_version[c$id$orig_h, T] == 1 )
		print ssh_log, fmt("%s %s \"%s\"", c$id$orig_h, "C", version);

	skip_further_processing(c$id);
	set_record_packets(c$id, F);
	}

event ssh_server_version(c: connection, version: string)
	{
	if ( ++did_ssh_version[c$id$resp_h, F] == 1 )
		print ssh_log, fmt("%s %s \"%s\"", c$id$resp_h, "S", version);
	}
