# $Id: ssl-ciphers.bro,v 1.1.1.1 2004/04/30 00:31:28 jason Exp $

# --- constant definitions of the cipher specs ---

# --- sslv2 ---
const SSLv20_CK_RC4_128_WITH_MD5 = 0x010080;
const SSLv20_CK_RC4_128_EXPORT40_WITH_MD5 = 0x020080;
const SSLv20_CK_RC2_128_CBC_WITH_MD5 = 0x030080;
const SSLv20_CK_RC2_128_CBC_EXPORT40_WITH_MD5 = 0x040080;
const SSLv20_CK_IDEA_128_CBC_WITH_MD5 = 0x050080;
const SSLv20_CK_DES_64_CBC_WITH_MD5 = 0x060040;
const SSLv20_CK_DES_192_EDE3_CBC_WITH_MD5 = 0x0700C0;

# --- sslv3x ---

const SSLv3x_NULL_WITH_NULL_NULL  = 0x0000;

# The following CipherSuite definitions require that the server
# provide an RSA certificate that can be used for key exchange.  The
# server may request either an RSA or a DSS signature-capable
# certificate in the certificate request message.

const SSLv3x_RSA_WITH_NULL_MD5 = 0x0001;
const SSLv3x_RSA_WITH_NULL_SHA = 0x0002;
const SSLv3x_RSA_EXPORT_WITH_RC4_40_MD5 = 0x0003;
const SSLv3x_RSA_WITH_RC4_128_MD5 = 0x0004;
const SSLv3x_RSA_WITH_RC4_128_SHA = 0x0005;
const SSLv3x_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 0x0006;
const SSLv3x_RSA_WITH_IDEA_CBC_SHA = 0x0007;
const SSLv3x_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x0008;
const SSLv3x_RSA_WITH_DES_CBC_SHA = 0x0009;
const SSLv3x_RSA_WITH_3DES_EDE_CBC_SHA = 0x000A;

# The following CipherSuite definitions are used for
# server-authenticated (and optionally client-authenticated)
# Diffie-Hellman.  DH denotes cipher suites in which the server's
# certificate contains the Diffie-Hellman parameters signed by the
# certificate authority (CA).  DHE denotes ephemeral Diffie-Hellman,
# where the Diffie-Hellman parameters are signed by a DSS or RSA
# certificate, which has been signed by the CA.  The signing
# algorithm used is specified after the DH or DHE parameter.  In all
# cases, the client must have the same type of certificate, and must
# use the Diffie-Hellman parameters chosen by the server.

const SSLv3x_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 0x000B;
const SSLv3x_DH_DSS_WITH_DES_CBC_SHA = 0x000C;
const SSLv3x_DH_DSS_WITH_3DES_EDE_CBC_SHA = 0x000D;
const SSLv3x_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x000E;
const SSLv3x_DH_RSA_WITH_DES_CBC_SHA = 0x000F;
const SSLv3x_DH_RSA_WITH_3DES_EDE_CBC_SHA = 0x0010;
const SSLv3x_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 0x0011;
const SSLv3x_DHE_DSS_WITH_DES_CBC_SHA = 0x0012;
const SSLv3x_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 0x0013;
const SSLv3x_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x0014;
const SSLv3x_DHE_RSA_WITH_DES_CBC_SHA = 0x0015;
const SSLv3x_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 0x0016;

#  The following cipher suites are used for completely anonymous
#  Diffie-Hellman communications in which neither party is
#  authenticated.  Note that this mode is vulnerable to
#  man-in-the-middle attacks and is therefore strongly discouraged.

const SSLv3x_DH_anon_EXPORT_WITH_RC4_40_MD5 = 0x0017;
const SSLv3x_DH_anon_WITH_RC4_128_MD5 = 0x0018;
const SSLv3x_DH_anon_EXPORT_WITH_DES40_CBC_SHA = 0x0019;
const SSLv3x_DH_anon_WITH_DES_CBC_SHA = 0x001A;
const SSLv3x_DH_anon_WITH_3DES_EDE_CBC_SHA = 0x001B;

#   The final cipher suites are for the FORTEZZA token.

const SSLv3x_FORTEZZA_KEA_WITH_NULL_SHA = 0x001C;
const SSLv3x_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA = 0x001D;
const SSLv3x_FORTEZZA_KEA_WITH_RC4_128_SHA = 0x001E;


# Cipher specifications native to TLS can be included in Version 2.0 client
# hello messages using the syntax below. Any V2CipherSpec element with its
# first byte equal to zero will be ignored by Version 2.0 servers. Clients
# sending any of the above V2CipherSpecs should also include the TLS equivalent
# (see Appendix A.5):
# V2CipherSpec (see TLS name) = { 0x00, CipherSuite };


# --- This is a table of all known cipher specs.
# --- It can be used for detecting unknown ciphers and for
# --- converting the cipher spec constants into a human readable format.

const ssl_cipher_desc: table[count] of string = {
	# --- sslv20 ---
	[SSLv20_CK_RC4_128_EXPORT40_WITH_MD5] =
		"SSLv20_CK_RC4_128_EXPORT40_WITH_MD5",
	[SSLv20_CK_RC4_128_WITH_MD5] = "SSLv20_CK_RC4_128_WITH_MD5",
	[SSLv20_CK_RC2_128_CBC_WITH_MD5] = "SSLv20_CK_RC2_128_CBC_WITH_MD5",
	[SSLv20_CK_RC2_128_CBC_EXPORT40_WITH_MD5] =
		"SSLv20_CK_RC2_128_CBC_EXPORT40_WITH_MD5",
	[SSLv20_CK_IDEA_128_CBC_WITH_MD5] = "SSLv20_CK_IDEA_128_CBC_WITH_MD5",
	[SSLv20_CK_DES_192_EDE3_CBC_WITH_MD5] =
		"SSLv20_CK_DES_192_EDE3_CBC_WITH_MD5",
	[SSLv20_CK_DES_64_CBC_WITH_MD5] = "SSLv20_CK_DES_64_CBC_WITH_MD5",

	# --- sslv3x ---
	[SSLv3x_NULL_WITH_NULL_NULL] = "SSLv3x_NULL_WITH_NULL_NULL",

	[SSLv3x_RSA_WITH_NULL_MD5] = "SSLv3x_RSA_WITH_NULL_MD5",
	[SSLv3x_RSA_WITH_NULL_SHA] = "SSLv3x_RSA_WITH_NULL_SHA",
	[SSLv3x_RSA_EXPORT_WITH_RC4_40_MD5] =
		"SSLv3x_RSA_EXPORT_WITH_RC4_40_MD5",
	[SSLv3x_RSA_WITH_RC4_128_MD5] = "SSLv3x_RSA_WITH_RC4_128_MD5",
	[SSLv3x_RSA_WITH_RC4_128_SHA] = "SSLv3x_RSA_WITH_RC4_128_SHA",
	[SSLv3x_RSA_EXPORT_WITH_RC2_CBC_40_MD5] =
		"SSLv3x_RSA_EXPORT_WITH_RC2_CBC_40_MD5",
	[SSLv3x_RSA_WITH_IDEA_CBC_SHA] = "SSLv3x_RSA_WITH_IDEA_CBC_SHA",
	[SSLv3x_RSA_EXPORT_WITH_DES40_CBC_SHA] =
		"SSLv3x_RSA_EXPORT_WITH_DES40_CBC_SHA",
	[SSLv3x_RSA_WITH_DES_CBC_SHA] = "SSLv3x_RSA_WITH_DES_CBC_SHA",
	[SSLv3x_RSA_WITH_3DES_EDE_CBC_SHA] = "SSLv3x_RSA_WITH_3DES_EDE_CBC_SHA",

	[SSLv3x_DH_DSS_EXPORT_WITH_DES40_CBC_SHA] =
		"SSLv3x_DH_DSS_EXPORT_WITH_DES40_CBC_SHA",
	[SSLv3x_DH_DSS_WITH_DES_CBC_SHA] = "SSLv3x_DH_DSS_WITH_DES_CBC_SHA",
	[SSLv3x_DH_DSS_WITH_3DES_EDE_CBC_SHA] =
		"SSLv3x_DH_DSS_WITH_3DES_EDE_CBC_SHA",
	[SSLv3x_DH_RSA_EXPORT_WITH_DES40_CBC_SHA] =
		"SSLv3x_DH_RSA_EXPORT_WITH_DES40_CBC_SHA",
	[SSLv3x_DH_RSA_WITH_DES_CBC_SHA] = "SSLv3x_DH_RSA_WITH_DES_CBC_SHA",
	[SSLv3x_DH_RSA_WITH_3DES_EDE_CBC_SHA] =
		"SSLv3x_DH_RSA_WITH_3DES_EDE_CBC_SHA",
	[SSLv3x_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA] =
		"SSLv3x_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA",
	[SSLv3x_DHE_DSS_WITH_DES_CBC_SHA] = "SSLv3x_DHE_DSS_WITH_DES_CBC_SHA",
	[SSLv3x_DHE_DSS_WITH_3DES_EDE_CBC_SHA] =
		"SSLv3x_DHE_DSS_WITH_3DES_EDE_CBC_SHA",
	[SSLv3x_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA] =
		"SSLv3x_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA",
	[SSLv3x_DHE_RSA_WITH_DES_CBC_SHA] = "SSLv3x_DHE_RSA_WITH_DES_CBC_SHA",
	[SSLv3x_DHE_RSA_WITH_3DES_EDE_CBC_SHA] =
		"SSLv3x_DHE_RSA_WITH_3DES_EDE_CBC_SHA",

	[SSLv3x_DH_anon_EXPORT_WITH_RC4_40_MD5] =
		"SSLv3x_DH_anon_EXPORT_WITH_RC4_40_MD5",
	[SSLv3x_DH_anon_WITH_RC4_128_MD5] = "SSLv3x_DH_anon_WITH_RC4_128_MD5",
	[SSLv3x_DH_anon_EXPORT_WITH_DES40_CBC_SHA] =
		"SSLv3x_DH_anon_EXPORT_WITH_DES40_CBC_SHA",
	[SSLv3x_DH_anon_WITH_DES_CBC_SHA] = "SSLv3x_DH_anon_WITH_DES_CBC_SHA",
	[SSLv3x_DH_anon_WITH_3DES_EDE_CBC_SHA] =
		"SSLv3x_DH_anon_WITH_3DES_EDE_CBC_SHA",

	[SSLv3x_FORTEZZA_KEA_WITH_NULL_SHA] =
		"SSLv3x_FORTEZZA_KEA_WITH_NULL_SHA",
	[SSLv3x_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA] =
		"SSLv3x_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA",
	[SSLv3x_FORTEZZA_KEA_WITH_RC4_128_SHA] =
		"SSLv3x_FORTEZZA_KEA_WITH_RC4_128_SHA"
};


# --- the following sets are provided for convenience

# --- this set holds all EXPORT ciphers
const ssl_cipherset_EXPORT: set[count] = {
	SSLv20_CK_RC4_128_EXPORT40_WITH_MD5,
	SSLv20_CK_RC2_128_CBC_EXPORT40_WITH_MD5,
	SSLv3x_RSA_EXPORT_WITH_RC4_40_MD5,
	SSLv3x_RSA_EXPORT_WITH_RC2_CBC_40_MD5,
	SSLv3x_RSA_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DH_DSS_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DH_RSA_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DH_anon_EXPORT_WITH_RC4_40_MD5,
	SSLv3x_DH_anon_EXPORT_WITH_DES40_CBC_SHA
};

# --- this set holds all DES ciphers
const ssl_cipherset_DES: set[count] = {
	SSLv20_CK_DES_64_CBC_WITH_MD5,
	SSLv3x_RSA_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_RSA_WITH_DES_CBC_SHA,
	SSLv3x_DH_DSS_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DH_DSS_WITH_DES_CBC_SHA,
	SSLv3x_DH_RSA_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DH_RSA_WITH_DES_CBC_SHA,
	SSLv3x_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DHE_DSS_WITH_DES_CBC_SHA,
	SSLv3x_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DHE_RSA_WITH_DES_CBC_SHA,
	SSLv3x_DH_anon_EXPORT_WITH_DES40_CBC_SHA,
	SSLv3x_DH_anon_WITH_DES_CBC_SHA
};


# --- this set holds all 3DES ciphers
const ssl_cipherset_3DES: set[count] = {
	SSLv20_CK_DES_192_EDE3_CBC_WITH_MD5,
	SSLv3x_DH_DSS_WITH_3DES_EDE_CBC_SHA,
	SSLv3x_DH_RSA_WITH_3DES_EDE_CBC_SHA,
	SSLv3x_DHE_DSS_WITH_3DES_EDE_CBC_SHA,
	SSLv3x_DHE_RSA_WITH_3DES_EDE_CBC_SHA,
	SSLv3x_DH_anon_WITH_3DES_EDE_CBC_SHA
};

# --- this set holds all RC2 ciphers
const ssl_cipherset_RC2: set[count] = {
	SSLv20_CK_RC2_128_CBC_WITH_MD5,
	SSLv20_CK_RC2_128_CBC_EXPORT40_WITH_MD5,
	SSLv3x_RSA_EXPORT_WITH_RC2_CBC_40_MD5
};

# --- this set holds all RC4 ciphers
const ssl_cipherset_RC4: set[count] = {
	SSLv20_CK_RC4_128_WITH_MD5,
	SSLv20_CK_RC4_128_EXPORT40_WITH_MD5,
	SSLv3x_RSA_EXPORT_WITH_RC4_40_MD5,
	SSLv3x_RSA_WITH_RC4_128_MD5,
	SSLv3x_RSA_WITH_RC4_128_SHA,
	SSLv3x_DH_anon_EXPORT_WITH_RC4_40_MD5,
	SSLv3x_DH_anon_WITH_RC4_128_MD5,
	SSLv3x_FORTEZZA_KEA_WITH_RC4_128_SHA
};

# --- this set holds all IDEA ciphers
const ssl_cipherset_IDEA: set[count] = {
	SSLv20_CK_IDEA_128_CBC_WITH_MD5,
	SSLv3x_RSA_WITH_IDEA_CBC_SHA
};
