# $Id: ssl-errors.bro,v 1.1.1.1 2004/04/30 00:31:28 jason Exp $

# --- const defns of error messages
const X509_V_OK = +0;
const X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT = +1;
const X509_V_ERR_UNABLE_TO_GET_CRL = +2;
const X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE = +3;
const X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE = +4;
const X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY = +5;
const X509_V_ERR_CERT_SIGNATURE_FAILURE = +6;
const X509_V_ERR_CRL_SIGNATURE_FAILURE = +7;
const X509_V_ERR_CERT_NOT_YET_VALID = +8;
const X509_V_ERR_CERT_HAS_EXPIRED = +9;
const X509_V_ERR_CRL_NOT_YET_VALID = +10;
const X509_V_ERR_CRL_HAS_EXPIRED = +11;
const X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD = +12;
const X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD = +13;
const X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD = +14;
const X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD = +15;
const X509_V_ERR_OUT_OF_MEM = +16;
const X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT = +17;
const X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN = +18;
const X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY = +19;
const X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE = +20;
const X509_V_ERR_CERT_CHAIN_TOO_LONG = +21;
const X509_V_ERR_CERT_REVOKED = +22;
const X509_V_ERR_INVALID_CA = +23;
const X509_V_ERR_PATH_LENGTH_EXCEEDED = +24;
const X509_V_ERR_INVALID_PURPOSE = +25;
const X509_V_ERR_CERT_UNTRUSTED = +26;
const X509_V_ERR_CERT_REJECTED = +27;
const X509_V_ERR_SUBJECT_ISSUER_MISMATCH = +28;
const X509_V_ERR_AKID_SKID_MISMATCH = +29;
const X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH = +30;
const X509_V_ERR_KEYUSAGE_NO_CERTSIGN = +31;
const X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER = +32;
const X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION = +33;

const x509_errors: table[int] of string = {
	[+0] = "X509_V_OK",
	[+1] = "X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT",
	[+2] = "X509_V_ERR_UNABLE_TO_GET_CRL",
	[+3] = "X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE",
	[+4] = "X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE",
	[+5] = "X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY",
	[+6] = "X509_V_ERR_CERT_SIGNATURE_FAILURE",
	[+7] = "X509_V_ERR_CRL_SIGNATURE_FAILURE",
	[+8] = "X509_V_ERR_CERT_NOT_YET_VALID",
	[+9] = "X509_V_ERR_CERT_HAS_EXPIRED",
	[+10] = "X509_V_ERR_CRL_NOT_YET_VALID",
	[+11] = "X509_V_ERR_CRL_HAS_EXPIRED",
	[+12] = "X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD",
	[+13] = "X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD",
	[+14] = "X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD",
	[+15] = "X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD",
	[+16] = "X509_V_ERR_OUT_OF_MEM",
	[+17] = "X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT",
	[+18] = "X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN",
	[+19] = "X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY",
	[+20] = "X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE",
	[+21] = "X509_V_ERR_CERT_CHAIN_TOO_LONG",
	[+22] = "X509_V_ERR_CERT_REVOKED",
	[+23] = "X509_V_ERR_INVALID_CA",
	[+24] = "X509_V_ERR_PATH_LENGTH_EXCEEDED",
	[+25] = "X509_V_ERR_INVALID_PURPOSE",
	[+26] = "X509_V_ERR_CERT_UNTRUSTED",
	[+27] = "X509_V_ERR_CERT_REJECTED",
	[+28] = "X509_V_ERR_SUBJECT_ISSUER_MISMATCH",
	[+29] = "X509_V_ERR_AKID_SKID_MISMATCH",
	[+30] = "X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH",
	[+31] = "X509_V_ERR_KEYUSAGE_NO_CERTSIGN",
	[+32] = "X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER",
	[+33] = "X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION"
};
