# $Id: tftp.bro,v 1.3 2005/03/17 09:18:28 vern Exp $

# Very simplistic - doesn't pick up the replies.

@load notice

redef enum Notice += {
	OutboundTFTP,		# outbound TFTP seen
};

redef capture_filters += { ["tftp"] = "udp port 69" };

@load udp-common
@load site

global tftp_notice_count: table[addr] of count &default = 0;

event udp_request(u: connection)
	{
	if ( u$id$resp_p == 69/udp && u$id$orig_p >= 1024/udp )
		{
		local src = u$id$orig_h;

		if ( is_local_addr(src) && ++tftp_notice_count[src] == 1 )
			NOTICE([$note=OutboundTFTP, $conn=u,
				$msg=fmt("outbound TFTP: %s -> %s", src, u$id$resp_h)]);
		}
	}
