// $Id: BPF_Program.h,v 1.2 2004/09/17 03:52:27 vern Exp $
//
// Copyright (c) 1996-2004
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef bpf_program_h
#define bpf_program_h

extern "C" {
#include <pcap.h>
}

#include "util.h"

// BPF_Programs are an abstraction around struct bpf_program,
// to create a clean facility for creating, compiling, and
// freeing such programs.

class BPF_Program {
public:
	// Creates an empty, uncompiled BPF program.
	BPF_Program();
	~BPF_Program();

	// Creates a BPF program for the given pcap handle.
	// Parameters are like in pcap_compile(). Returns true
	// for successful compilation, false otherwise.
	bool Compile(pcap_t* pcap, const char* filter, uint32 netmask,
		 char* errbuf = 0, unsigned int errbuf_len = 0,
		 bool optimize = true);

	// Creates a BPF program when no pcap handle is around,
	// similarly to pcap_compile_nopcap(). Parameters are
	// similar. Returns true on success.
	bool Compile(int snaplen, int linktype, const char* filter,
		uint32 netmask, char* errbuf = 0, bool optimize = true);

	// Returns true if this program currently contains compiled
	// code, false otherwise.
	bool IsCompiled()	{ return m_compiled; }

	// Accessor to the compiled program. Returns nil when
	// no program is currently compiled.
	bpf_program* GetProgram();

protected:
	void FreeCode();

	// (I like to prefix member variables with m_, makes it clear
	// in the implementation whether it's a global or not. --ck)
	bool m_compiled;
	struct bpf_program m_program;
};

#endif
