// $Id: BackDoor.h,v 1.2 2005/02/09 08:04:38 vern Exp $
//
// Copyright (c) 1999, 2000, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef backdoor_h
#define backdoor_h

#include "TCP.h"
#include "Timer.h"
#include "NetVar.h"
#include "Login.h"

class BackDoorEndpoint : public TCP_EndpointAnalyzer {
public:
	BackDoorEndpoint(TCP_Endpoint* e);

	int DataSent(double t, int seq, int len, const u_char* data,
		     const IP_Hdr* ip, const struct tcphdr* tp);

	RecordVal* BuildStats();

	void FinalCheckForRlogin();

protected:
	void CheckForRlogin(int seq, int len, const u_char* data);
	void RloginSignatureFound(int len);

	void CheckForTelnet(int seq, int len, const u_char* data);
	void TelnetSignatureFound(int len);

	void CheckForSSH(int seq, int len, const u_char* data);
	void CheckForFTP(int seq, int len, const u_char* data);
	void CheckForRootBackdoor(int seq, int len, const u_char* data);
	void CheckForNapster(int seq, int len, const u_char* data);
	void CheckForGnutella(int seq, int len, const u_char* data);
	void CheckForKazaa(int seq, int len, const u_char* data);
	void CheckForHTTP(int seq, int len, const u_char* data);
	void CheckForHTTPProxy(int seq, int len, const u_char* data);
	void CheckForSMTP(int seq, int len, const u_char* data);
	void CheckForIRC(int seq, int len, const u_char* data);
	void CheckForGaoBot(int seq, int len, const u_char* data);

	void SignatureFound(EventHandlerPtr e, int do_orig = 0);

	int CheckForStrings(const char** strs, const u_char* data, int len);
	int CheckForString(const char* str, const u_char* data, int len);

	int is_partial;
	int max_top_seq;

	int rlogin_checking_done;
	int rlogin_num_null;
	int rlogin_string_separator_pos;
	int rlogin_slash_seen;

	uint32 num_pkts;
	uint32 num_8k4_pkts;
	uint32 num_8k0_pkts;
	uint32 num_lines;
	uint32 num_normal_lines;
	uint32 num_bytes;
	uint32 num_7bit_ascii;
};

class BackDoorAnalyzer : public TCP_Analyzer {
public:
	BackDoorAnalyzer(TCP_Connection* c);
	~BackDoorAnalyzer();

	void Done();
	void StatTimer(double t, int is_expire);

protected:
	void StatEvent();
	void RemoveEvent();

	BackDoorEndpoint* orig_endp;
	BackDoorEndpoint* resp_endp;
	double timeout;
	double backoff;
};

class BackDoorTimer : public Timer {
public:
	BackDoorTimer(double t, BackDoorAnalyzer* a);
	~BackDoorTimer();

	void Dispatch(double t, int is_expire);

protected:
	BackDoorAnalyzer* analyzer;
};

#endif
