// $Id: BroString.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1997, 1998, 1999, 2002, 2003
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef brostring_h
#define brostring_h

#include <vector>
#include <stdlib.h>
#include <sys/types.h>
using namespace std;

#include "util.h"

typedef u_char* byte_vec;

class BroString {
public:
	BroString(int arg_final_NUL, byte_vec str, int arg_n);
	BroString(const u_char* str, int arg_n, int add_NUL);
	BroString(const char* str);
	~BroString()
		{
		if ( use_free_to_delete )
			free(b);
		else
			delete [] b;
		}

	byte_vec Bytes() const	{ return b; }
	int Len() const			{ return n; }

	void SetUseFreeToDelete(int use_it)
		{ use_free_to_delete = use_it; }

	const char* CheckString() const;

	enum expansion_style {
		EXPANDED_STRING,	// the original style
		BRO_STRING_LITERAL,	// as in a Bro string literal
	};
	char* ExpandedString(int format = EXPANDED_STRING) const;

	void ToUpper();

	unsigned int MemoryAllocation() const
		{ return padded_sizeof(*this) + pad_size(n + final_NUL); }

protected:
	byte_vec b;
	int n;
	unsigned int final_NUL:1;	// whether we have added a final NUL
	unsigned int use_free_to_delete:1;	// free() vs. operator delete
};

extern int Bstr_eq(const BroString* s1, const BroString* s2);
extern int Bstr_cmp(const BroString* s1, const BroString* s2);

// A data_chunk_t specifies a length-delimited constant string. It is
// often used for substrings of other BroString's to avoid memory copy,
// which would be necessary if BroString were used. Unlike BroString,
// the string should not be deallocated on destruction.
//
// "BroConstString" might be a better name here.

struct data_chunk_t {
	int length;
	const char* data;
};

extern BroString* concatenate(std::vector<data_chunk_t>& v);
extern BroString* concatenate(std::vector<const BroString*>& v);
extern void delete_strings(std::vector<const BroString*>& v);

#endif
