// $Id: Continuation.h,v 1.1 2004/09/17 03:25:12 vern Exp $
//
// Helper class to implement continuation-like mechanisms for
// suspending/resuming tasks for incremental operation.
//
// TODO: - Document how to use this.
//       - Find some nice macro-based interface?

#ifndef continuation_h
#define continuation_h

#include "List.h"

class Continuation {
public:
	Continuation()	{ current_level = 0; suspend_level = -1; }

	bool NewInstance() const
		{ return suspend_level < current_level; }
	bool ChildSuspended() const
		{ return suspend_level > current_level;  }
	bool Resuming() const
		{ return suspend_level == current_level; }

	void Suspend(void* user_ptr = 0)
		{
		suspend_level = current_level;
		states.replace(current_level, user_ptr);
		}

	void SaveContext()		{ ++current_level; }
	void RestoreContext()		{ --current_level; }
	void* RestoreState() const	{ return states[current_level]; }

private:
	int current_level;
	int suspend_level;

	declare(PList, void);
	typedef PList(void) voidp_list;

	voidp_list states;
};

#endif
