// $Id: DCE_RPC.cc,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2000, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "config.h"

#include <stdlib.h>

#include "DCE_RPC.h"
#include "Sessions.h"

#define xbyte(b, n) (((const u_char*) (b))[n])
#define extract_uint16(little_endian, bytes) \
	((little_endian) ? \
	 uint16(xbyte(bytes, 0)) | ((uint16(xbyte(bytes, 1))) << 8) : \
	 uint16(xbyte(bytes, 1)) | ((uint16(xbyte(bytes, 0))) << 8))

DCE_RPC_Header::DCE_RPC_Header(Connection* c, const u_char* b)
	{
	conn = c;
	bytes = b;

	// This checks whether it's both the first fragment *and*
	// the last fragment.
	if ( bytes[3] & 0x3 != 0x3 )
		{
		fragmented = 1;
		Weird("Fragmented DCE/RPC message");
		}
	else
		fragmented = 0;

	ptype = (enum DCE_RPC_PTYPE) bytes[2];
	frag_len = extract_uint16(LittleEndian(), bytes + 8);
	}

DCE_RPC_Session::DCE_RPC_Session(Connection* c)
	{
	conn = c;
	}

void DCE_RPC_Session::DeliverPDU(int is_orig, int len, const u_char* data)
	{
	EventHandlerPtr f = is_orig ? dce_rpc_request : dce_rpc_reply;
	if ( f )
		{
		val_list* vl = new val_list;
		vl->append(conn->BuildConnVal());
		vl->append(new EnumVal(data[2], dce_rpc_ptype));
		vl->append(new StringVal(len, (const char*) data));
		conn->ConnectionEvent(f, vl);
		}
	}
	
TCP_Contents_DCE_RPC::TCP_Contents_DCE_RPC(TCP_Endpoint* arg_endp, 
		DCE_RPC_Session* arg_session)
: TCP_Contents(arg_endp)
	{
	session = arg_session;
	msg_buf = 0;
	buf_len = 0;
	Init();
	}

void TCP_Contents_DCE_RPC::Init()
	{
	// Allocate space for header.
	if ( ! msg_buf )
		{
		buf_len = DCE_RPC_HEADER_LENGTH;
		msg_buf = new u_char[buf_len];
		}

	buf_n = 0;
	msg_len = 0;
	hdr = 0;
	}

TCP_Contents_DCE_RPC::~TCP_Contents_DCE_RPC()
	{
	delete [] msg_buf;
	delete hdr;
	}

void TCP_Contents_DCE_RPC::Deliver(int seq, int len, u_char* data)
	{
	ASSERT(buf_len >= DCE_RPC_HEADER_LENGTH);
	while ( len > 0 )
		{
		if ( buf_n < DCE_RPC_HEADER_LENGTH )
			{
			while ( buf_n < DCE_RPC_HEADER_LENGTH && len > 0 )
				{
				msg_buf[buf_n] = *data;
				++buf_n; ++data; --len;
				}

			if ( buf_n < DCE_RPC_HEADER_LENGTH )
				break;
			else
				ParseHeader();
			}
	
		while ( buf_n < msg_len && len > 0 )
			{
			msg_buf[buf_n] = *data;
			++buf_n; ++data; --len;
			}
	
		if ( buf_n < msg_len )
			break;
		else
			{
			DeliverPDU(msg_len, msg_buf);
			// Reset for next message
			Init();
			}
		}
	}

void TCP_Contents_DCE_RPC::DeliverPDU(int len, const u_char* data)
	{ 
	session->DeliverPDU(IsOrig(), len, data);
	}

void TCP_Contents_DCE_RPC::ParseHeader()
	{
	delete hdr;
	hdr = new DCE_RPC_Header(endp->Conn(), msg_buf);
	msg_len = hdr->FragLen();
	if ( msg_len > buf_len )
		{
		u_char* new_msg_buf = new u_char[msg_len];
		memcpy(new_msg_buf, msg_buf, buf_n);
		delete [] msg_buf;
		buf_len = msg_len;
		msg_buf = new_msg_buf;
		hdr->SetBytes(new_msg_buf);
		}
	}
	
DCE_RPC_Conn::DCE_RPC_Conn(NetSessions* s, HashKey* k, double t, const ConnID* id,
		const struct tcphdr* tp)
: TCP_Connection(s, k, t, id, tp)
	{
	o_dce_rpc = r_dce_rpc = 0;
	session = new DCE_RPC_Session(this);
	}

DCE_RPC_Conn::~DCE_RPC_Conn()
	{
	delete session;
	}

void DCE_RPC_Conn::BuildEndpoints()
	{
	o_dce_rpc = new TCP_Contents_DCE_RPC(orig, session);
	r_dce_rpc = new TCP_Contents_DCE_RPC(resp, session);

	orig->AddContentsProcessor(o_dce_rpc);
	resp->AddContentsProcessor(r_dce_rpc);
	}
