// $Id: DCE_RPC.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2000, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef dce_rpc_h
#define dce_rpc_h

// NOTE: This is a very *crude* analyzer for DCE/RPC (used on Microsoft
// Windows systems) and shouldn't be considered as stable.

#include "TCP.h"

enum DCE_RPC_PTYPE {
	DCE_RPC_REQUEST, DCE_RPC_PING, DCE_RPC_RESPONSE, DCE_RPC_FAULT,
	DCE_RPC_WORKING, DCE_RPC_NOCALL, DCE_RPC_REJECT, DCE_RPC_ACK,
	DCE_RPC_CL_CANCEL, DCE_RPC_FACK, DCE_RPC_CANCEL_ACK, DCE_RPC_BIND,
	DCE_RPC_BIND_ACK, DCE_RPC_BIND_NAK, DCE_RPC_ALTER_CONTEXT,
	DCE_RPC_ALTER_CONTEXT_RESP, DCE_RPC_SHUTDOWN, DCE_RPC_CO_CANCEL,
	DCE_RPC_ORPHANED,
};

#define DCE_RPC_HEADER_LENGTH 16

class DCE_RPC_Header {
public:
	DCE_RPC_Header(Connection* conn, const u_char* bytes);

	enum DCE_RPC_PTYPE PTYPE() const	{ return ptype; }
	int FragLen() const		{ return frag_len; }
	int LittleEndian() const	{ return bytes[4] >> 4; }
	bool Fragmented() const		{ return fragmented; }

	void Weird(const char* msg)	{ conn->Weird(msg); }
	void SetBytes(const u_char* b)	{ bytes = b; }

protected:
	Connection* conn;
	const u_char* bytes;
	enum DCE_RPC_PTYPE ptype;
	int frag_len;
	bool fragmented;
};

// Create a general DCE_RPC_Session class so that it can be used in
// case the RPC conversation is tunneled through other connections,
// e.g. through an SMB session.

class DCE_RPC_Session {
public:
	DCE_RPC_Session(Connection* conn);
	virtual void DeliverPDU(int is_orig, int len, const u_char* data);

protected:
	Connection* conn;
};

class TCP_Contents_DCE_RPC : public TCP_Contents {
public:
	TCP_Contents_DCE_RPC(TCP_Endpoint* endp, DCE_RPC_Session* session);
	~TCP_Contents_DCE_RPC();

protected:
	void Init();

	void Deliver(int seq, int len, u_char* data);
	virtual void DeliverPDU(int len, const u_char* data);
	void ParseHeader();

	DCE_RPC_Session* session;
	u_char* msg_buf;
	int msg_len;
	int buf_n;	// number of bytes in msg_buf
	int buf_len;	// size off msg_buf
	DCE_RPC_Header* hdr;
};

class DCE_RPC_Conn : public TCP_Connection {
public:
	DCE_RPC_Conn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	~DCE_RPC_Conn();

protected:
	void BuildEndpoints();
	
	DCE_RPC_Session* session;
	TCP_Contents_DCE_RPC* o_dce_rpc;
	TCP_Contents_DCE_RPC* r_dce_rpc;
};

#endif /* dce_rpc_h */
