// $Id: EquivClass.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1998, 1999, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef equiv_class_h
#define equiv_class_h

#include <stdio.h>

#include "CCL.h"

class EquivClass {
public:
	EquivClass(int size);
	~EquivClass();

	void UniqueChar(int sym);
	void CCL_Use(CCL* ccl);

	// All done adding character usage info - generate equivalence
	// classes.  Returns number of classes.
	int BuildECs();

	void ConvertCCL(CCL* ccl);

	int IsRep(int sym) const		{ return rep[sym] == sym; }
	int EquivRep(int sym) const		{ return rep[sym]; }
	int SymEquivClass(int sym) const	{ return equiv_class[sym]; }
	int* EquivClasses() const		{ return equiv_class; }

	int NumSyms() const	{ return size; }
	int NumClasses() const	{ return num_ecs; }

	void Dump(FILE* f);
	int Size() const;

protected:
	int size;	// size of character set
	int num_ecs;	// size of equivalence classes
	int* fwd;	// forward list of different classes
	int* bck;	// backward list
	int* equiv_class;	// symbol's equivalence class
	int* rep;	// representative for symbol's equivalence class
	int* ccl_flags;
	int ec_nil, no_class, no_rep;
};

#endif
