// $Id: Event.cc,v 1.3 2004/09/28 03:30:23 vern Exp $
//
// Copyright (c) 1995, 1996, 1997, 1998, 1999, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "config.h"

#include "Event.h"
#include "Func.h"
#include "NetVar.h"

EventMgr mgr;

int num_events_queued = 0;
int num_events_dispatched = 0;

Event::Event(EventHandlerPtr arg_handler, val_list* arg_args,
		SourceID arg_src, BroObj* arg_obj)
	{
	handler = arg_handler;
	args = arg_args;
	src = arg_src;
	obj = arg_obj;

	if ( obj )
		Ref(obj);

	next_event = 0;
	}

Event::~Event()
	{
	// We don't Unref() the individual arguments by using delete_vals()
	// here, because Func::Call already did that.
	delete args;
	}

void Event::Describe(ODesc* d) const
	{
	if ( d->IsReadable() )
		d->AddSP("event");

	int s = d->IsShort();
	d->SetShort();
//	handler->Describe(d);
	d->SetShort(s);

	if ( ! d->IsBinary() )
		d->Add("(");
	describe_vals(args, d);
	if ( ! d->IsBinary() )
		d->Add("(");
	}

EventMgr::EventMgr()
	{
	head = tail = 0;
	current_src = SOURCE_LOCAL;
	src_val = 0;
	draining = 0;
	}

EventMgr::~EventMgr()
	{
	while ( head )
		{
		Event* n = head->NextEvent();
		Unref(head);
		head = n;
		}

	Unref(src_val);
	}

void EventMgr::QueueEvent(Event* event)
	{
	if ( ! head )
		head = tail = event;
	else
		{
		tail->SetNext(event);
		tail = event;
		}

	++num_events_queued;
	}

void EventMgr::Dispatch()
	{
	if ( ! head )
		internal_error("EventMgr underflow");

	Event* current = head;

	head = head->NextEvent();
	if ( ! head )
		tail = head;

	current_src = current->Source();
	current->Dispatch();
	Unref(current);

	++num_events_dispatched;
	}

void EventMgr::Drain()
	{
	SegmentProfiler(segment_logger, "draining-events");

	draining = true;
	while ( head )
		Dispatch();

	// Note: we might eventually need a general way to specify things to
	// do after draining events.
	extern void flush_rewriter_packet();
	flush_rewriter_packet();

	draining = false;
	}

void EventMgr::Describe(ODesc* d) const
	{
	int n = 0;
	Event* e;
	for ( e = head; e; e = e->NextEvent() )
		++n;

	d->AddCount(n);

	for ( e = head; e; e = e->NextEvent() )
		{
		e->Describe(d);
		d->NL();
		}
	}

RecordVal* EventMgr::GetLocalPeerVal()
	{
	if ( ! src_val )
		{
		src_val = new RecordVal(peer);
		src_val->Assign(0, new Val(0, TYPE_COUNT));
		src_val->Assign(1, new AddrVal("127.0.0.1"));
		src_val->Assign(2, new PortVal(0));
		src_val->Assign(3, new Val(true, TYPE_BOOL));

		Ref(peer_description);
		src_val->Assign(4, peer_description);
		}

	Ref(src_val);

	return src_val;
	}
