// $Id: Event.h,v 1.3 2004/09/28 03:30:23 vern Exp $
//
// Copyright (c) 1995, 1996, 1997, 1998, 1999, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef event_h
#define event_h

#include "EventRegistry.h"
#include "Serializer.h"

class EventMgr;

class Event : public BroObj {
public:
	Event(EventHandlerPtr handler, val_list* args,
		SourceID src = SOURCE_LOCAL, BroObj* obj = 0);
	~Event();

	void SetNext(Event* n)		{ next_event = n; }
	Event* NextEvent() const	{ return next_event; }

	SourceID Source() const		{ return src; }

	void Describe(ODesc* d) const;

protected:
	friend class EventMgr;

	// This method is protected to make sure that everybody goes through
	// EventMgr::Dispatch().
	void Dispatch(bool no_remote = false)
		{
		if ( event_serializer )
			{
			SerialInfo info(event_serializer);
			event_serializer->Serialize(&info, handler->Name(), args);
			}

		handler->Call(args, no_remote);
		if ( obj )
			// obj->EventDone();
			Unref(obj);
		}

	EventHandlerPtr handler;
	val_list* args;
	SourceID src;
	BroObj* obj;
	Event* next_event;
};

extern int num_events_queued;
extern int num_events_dispatched;

class EventMgr : public BroObj {
public:
	EventMgr();
	~EventMgr();

	void QueueEvent(EventHandlerPtr h, val_list* vl,
			SourceID src = SOURCE_LOCAL, BroObj* obj = 0)
		{
		if ( h )
			QueueEvent(new Event(h, vl, src, obj));
		}

	void Dispatch();

	void Dispatch(Event* event, bool no_remote = false)
		{
		current_src = event->Source();
		event->Dispatch(no_remote);
		Unref(event);
		}

	void Drain();
	bool IsDraining() const	{ return draining; }

	int HasEvents() const	{ return head != 0; }

	// Returns the source ID of last raised event.
	SourceID CurrentSource() const	{ return current_src; }

	int Size() const
		{ return num_events_queued - num_events_dispatched; }

	// Returns a peer record describing the local Bro.
	RecordVal* GetLocalPeerVal();

	void Describe(ODesc* d) const;

protected:
	void QueueEvent(Event* event);

	Event* head;
	Event* tail;
	SourceID current_src;
	RecordVal* src_val;
	bool draining;
};

extern EventMgr mgr;

#endif
