// $Id: EventHandler.h,v 1.4 2004/09/28 03:22:44 vern Exp $
//
// Capsulates local and remote event handlers.

#ifndef EVENTHANDLER
#define EVENTHANDLER

#include <assert.h>

#include "List.h"
#include "BroList.h"
#include "net_util.h"

class Func;
class FuncType;
class Serializer;
class SerialInfo;
class UnserialInfo;

class EventHandler {
public:
	EventHandler(const char* name);
	~EventHandler();

	const char* Name()	{ return name; }
	Func* LocalHandler()	{ return local; }
	FuncType* FType();

	void SetLocalHandler(Func* f);

	void AddRemoteHandler(SourceID peer);
	void RemoveRemoteHandler(SourceID peer);

	void Call(val_list* vl, bool no_remote = false);

	// Returns true if there is at least one local or remote handler.
	operator  bool() const	{ return local || receivers.length(); }

	void SetUsed()          { used = true; }
	bool Used()             { return used; }

	// We don't serialize the handler(s) itself here, but
	// just the reference to it.
	bool Serialize(SerialInfo* info) const;
	static EventHandler* Unserialize(UnserialInfo* info);

private:
	const char* name;
	Func* local;
	FuncType* type;
	bool used;		// this handler is indeed used somewhere

	declare(List, SourceID);
	typedef List(SourceID) receiver_list;
	receiver_list receivers;
};

// Encapsulates a ptr to an event handler to overload the boolean operator.
class EventHandlerPtr {
public:
	EventHandlerPtr(EventHandler* p = 0)		{ handler = p; }
	EventHandlerPtr(const EventHandlerPtr& h)	{ handler = h.handler; }

	const EventHandlerPtr& operator=(EventHandler* p)
		{ handler = p; return *this; }
	const EventHandlerPtr& operator=(const EventHandlerPtr& h)
		{ handler = h.handler; return *this; }

	EventHandler* Ptr()	{ return handler; }

	operator bool() const	{ return handler && *handler; }
	EventHandler* operator->()	{ return handler; }
	const EventHandler* operator->() const	{ return handler; }

private:
	EventHandler* handler;
};

#endif
