// $Id: FTP.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef ftp_h
#define ftp_h

#include "NVT.h"

class FTP_Conn : public TCP_Connection {
public:
	FTP_Conn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	void Done();

	int RewritingTrace()	{ return rewriting_ftp_trace; }

	void NewLine(TCP_ContentLine* sender, int length, const char* line);

protected:
	FTP_Conn()	{}

	DECLARE_SERIAL(FTP_Conn)

	void BuildEndpoints();

	TCP_NVT* o_nvt;
	TCP_NVT* r_nvt;
	uint32 pending_reply;	// code associated with multi-line reply, or 0
};

#endif
