// $Id: Func.h,v 1.5 2004/12/06 00:16:05 vern Exp $
//
// Copyright (c) 1995, 1996, 1997, 1998, 1999, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef func_h
#define func_h

#include "BroList.h"
#include "Obj.h"
#include "Debug.h"

class Val;
class ListExpr;
class FuncType;
class Stmt;
class Frame;
class ID;

class Func : public BroObj {
public:

	enum Kind { BRO_FUNC, BUILTIN_FUNC };

	Func(Kind arg_kind)
		{ scope = 0; kind = arg_kind; id = 0; return_value = 0; }

	virtual ~Func();

	virtual int IsPure() const = 0;
	int IsEvent() const	{ return FType()->IsEvent(); }

	virtual const vector<Stmt*>& GetBodies() const { return bodies; }

	// virtual Val* Call(ListExpr* args) const = 0;
	virtual Val* Call(val_list* args) const = 0;

	// Add a new event handler to an existing function (event).
	virtual void AddBody(Stmt* new_body, id_list* new_inits,
				int new_frame_size);

	virtual void SetScope(Scope* newscope)	{ scope = newscope; }
	virtual Scope* GetScope() const		{ return scope; }

	virtual FuncType* FType() const
		{
		return (FuncType*) id->Type()->AsFuncType();
		}

	Kind GetKind() const	{ return kind; }

	const ID* GetID() const { return id; }
	void SetID(ID *arg_id);

	virtual void Describe(ODesc* d) const = 0;
	virtual void DescribeDebug(ODesc* d, const val_list* args) const;

	// This (un-)serializes only a single body (as given in SerialInfo).
	bool Serialize(SerialInfo* info) const;
	static Func* Unserialize(UnserialInfo* info);

	ID* GetReturnValueID() const;
	virtual TraversalCode Traverse(TraversalCallback* cb) const;

protected:
	Func()	{ scope = 0; id = 0; return_value = 0; }

	DECLARE_ABSTRACT_SERIAL(Func);

	vector<Stmt*> bodies;
	Scope* scope;
	Kind kind;
	ID* id;
	ID* return_value;
};


class BroFunc : public Func {
public:
	BroFunc(ID* id, Stmt* body, id_list* inits, int frame_size);
	~BroFunc();

	int IsPure() const;
	Val* Call(val_list* args) const;

	void AddBody(Stmt* new_body, id_list* new_inits, int new_frame_size);

	int FrameSize() const {	return frame_size; }

	void Describe(ODesc* d) const;

protected:
	BroFunc() : Func(BRO_FUNC)	{}
	Stmt* AddInits(Stmt* body, id_list* inits);

	DECLARE_SERIAL(BroFunc);

	int frame_size;
};

typedef Val* (*built_in_func)(val_list* args);

class BuiltinFunc : public Func {
public:
	BuiltinFunc(built_in_func func, const char* name, int is_pure);
	~BuiltinFunc();

	int IsPure() const;
	Val* Call(val_list* args) const;
	const char* Name() const	{ return name; }

	void Describe(ODesc* d) const;

protected:
	BuiltinFunc()	{ func = 0; name = 0; is_pure = 0; }

	DECLARE_SERIAL(BuiltinFunc);

	built_in_func func;
	const char* name;
	int is_pure;
};


extern void builtin_run_time(const char* msg, BroObj* arg = 0);
extern void init_builtin_funcs();

// This global is set prior to the interpreter making a function call.
// It's there so that built-in functions can access the location information
// associated with a call when reporting error messages.
extern const Expr* calling_expr;

#endif
