// $Id: Gnutella.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef gnutella_h
#define gnutella_h

#include "TCP.h"

#define ORIG_OK               0x1
#define RESP_OK               0x2

#define GNUTELLA_MSG_SIZE     23
#define GNUTELLA_MAX_PAYLOAD  1024

class GnutellaMsgState {
public:
	GnutellaMsgState ();

	string buffer;
	int current_offset;
	int got_CR;
	string headers;
	char msg[GNUTELLA_MSG_SIZE];
	u_char msg_hops;
	unsigned int msg_len;
	int msg_pos;
	int msg_sent;
	u_char msg_type;
	u_char msg_ttl;
	char payload[GNUTELLA_MAX_PAYLOAD];
	int payload_len;
	unsigned int payload_left;
};


class GnutellaConn : public TCP_Connection {
public:
	GnutellaConn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	void Done ();
	void Deliver(TCP_Endpoint* s, int seq, int len, u_char* data);

protected:
	void BuildEndpoints ();

private:
	int NextLine(u_char* data, int len);

	int GnutellaOK(string header);
	int IsHTTP(string header);

	int Established() const	{ return state == (ORIG_OK | RESP_OK); }

	void DeliverLines(TCP_Endpoint* s, int seq, int len, u_char* data);
	void DeliverHTTP(TCP_Endpoint* s, int seq, int len, u_char* data);

	void SendEvents(GnutellaMsgState* p, bool is_orig);

	void DissectMessage(char* msg);
	void DeliverMessages(TCP_Endpoint* s, int seq, int len, u_char* data);

	NetSessions* orig_s;
	HashKey* orig_k;
	double orig_t;
	const ConnID* orig_id;
	const struct tcphdr* orig_tp;

	int state;
	int new_state;
	int sent_establish;
	TCP_Connection* http_conn;

	GnutellaMsgState* orig_msg_state;
	GnutellaMsgState* resp_msg_state;
	GnutellaMsgState* ms;
};

#endif
