// $Id: ICMP.h,v 1.3 2004/11/02 07:30:58 vern Exp $
//
// Copyright (c) 2000, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef icmp_h
#define icmp_h

#include "Conn.h"

class ICMP_Connection : public Connection {
public:
	ICMP_Connection(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct icmp* icmpp);

	void Done();

	void NextPacket(double t, int is_orig, const IP_Hdr* ip,
			int len, int caplen,
			const u_char*& data,
			int& record_packet, int& record_content,
			const struct pcap_pkthdr* hdr,
			const u_char* const pkt,
			int hdr_size);

	int IsReuse(double t, const u_char* pkt);

	TransportProto ConnTransport() const	{ return TRANSPORT_ICMP; }

	void ICMPEvent(EventHandlerPtr f);

	void Describe(ODesc* d) const;

	virtual unsigned int MemoryAllocation() const;

protected:
	ICMP_Connection()	{ }

	RecordVal* BuildICMPVal();
	void UpdateEndpointVal(RecordVal* /* endp */, int /* is_orig */);

	virtual void NextICMP(double t, const struct icmp* icmpp,
				int len, int caplen, const u_char*& data);

	RecordVal* ExtractICMPContext(int len, const u_char*& data);

	DECLARE_SERIAL(ICMP_Connection);

	RecordVal* icmp_conn_val;
	int type;
	int code;
	int len;
};

class ICMP_Echo : public ICMP_Connection {
public:
	ICMP_Echo(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct icmp* icmpp);

protected:
	ICMP_Echo()	{ }

	void NextICMP(double t, const struct icmp* icmpp,
				int len, int caplen, const u_char*& data);

	DECLARE_SERIAL(ICMP_Echo);
};

class ICMP_Context : public ICMP_Connection {
public:
	ICMP_Context(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct icmp* icmpp);

protected:
	ICMP_Context()	{ }

	void NextICMP(double t, const struct icmp* icmpp,
				int len, int caplen, const u_char*& data);

	DECLARE_SERIAL(ICMP_Context);
};

#endif
