// $Id: Ident.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1999, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef ident_h
#define ident_h

#include "TCP.h"

class IdentConn : public TCP_Connection {
public:
	IdentConn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	void Done();

	int RewritingTrace()	{ return rewriting_ident_trace; }

	void NewLine(TCP_ContentLine* sender, int length, const char* line);

protected:
	void BuildEndpoints();

	const char* ParsePair(const char* line, const char* end_of_line,
				int& p1, int &p2);
	const char* ParsePort(const char* line, const char* end_of_line,
				int& pn);

	void BadRequest(int length, const char* line);
	void BadReply(int length, const char* line);

	TCP_ContentLine* orig_ident;
	TCP_ContentLine* resp_ident;

	unsigned int did_deliver:1;
	unsigned int did_bad_reply:1;
};

#endif
