// $Id: InterConn.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1999, 2000, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef interconn_h
#define interconn_h

#include "TCP.h"
#include "Timer.h"
#include "NetVar.h"

class InterConnEndpoint : public TCP_EndpointAnalyzer {
public:
	InterConnEndpoint(TCP_Endpoint* e);

	int DataSent(double t, int seq, int len, const u_char* data,
		     const IP_Hdr* ip, const struct tcphdr* tp);

	RecordVal* BuildStats();

protected:
	int EstimateGapPacketNum(int gap) const;
	int IsPotentialKeystrokePacket(int len) const;
	int IsNormalKeystrokeInterarrival(double t) const;

	double last_keystroke_time;
	int max_top_seq;
	uint32 num_pkts;
	uint32 num_keystrokes_two_in_a_row;
	uint32 num_normal_interarrivals;
	uint32 num_8k4_pkts;
	uint32 num_8k0_pkts;
	uint32 num_bytes;
	uint32 num_7bit_ascii;
	uint32 num_lines;
	uint32 num_normal_lines;
	int is_partial;
	int keystroke_just_seen;
};

class InterConnAnalyzer : public TCP_Analyzer {
public:
	InterConnAnalyzer(TCP_Connection* c);
	~InterConnAnalyzer();

	void Done();
	void StatTimer(double t, int is_expire);

protected:
	void StatEvent();
	void RemoveEvent();

	InterConnEndpoint* orig_endp;
	InterConnEndpoint* resp_endp;

	double timeout;
	double backoff;
};

class InterConnTimer : public Timer {
public:
	InterConnTimer(double t, InterConnAnalyzer* a);
	~InterConnTimer();

	void Dispatch(double t, int is_expire);

protected:
	InterConnAnalyzer* analyzer;
};

#endif
