// $Id: Logger.h,v 1.2 2004/09/09 06:38:08 vern Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2000, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef logger_h
#define logger_h

#include "util.h"
#include "Obj.h"

class BroFile;
class Func;

class Logger : public BroObj {
public:
	Logger(const char* name, BroFile* f = 0);
	virtual ~Logger();

	void Log(const char* msg);

	void SetEnabled(int do_enabled)		{ enabled = do_enabled; }

	void Describe(ODesc* d) const;

protected:
	BroFile* f;	// associated file
	int enabled;	// if true, syslog'ing is done, otherwise just file log
};

extern Logger* bro_logger;
extern Func* alarm_hook;

#endif
