// $Id: NFS.h,v 1.1 2005/04/21 07:01:54 vern Exp $
//
// Copyright (c) 2005
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef nfs_h
#define nfs_h

#include "RPC.h"

class NFS_Interp : public RPC_Interpreter {
public:
	NFS_Interp(Connection* arg_conn) : RPC_Interpreter(arg_conn) { }

protected:
	int RPC_BuildCall(RPC_CallInfo* c, const u_char*& buf, int& n);
	int RPC_BuildReply(const RPC_CallInfo* c, int success,
				const u_char*& buf, int& n,
				EventHandlerPtr& event, Val*& reply);

	StringVal* ExtractFH(const u_char*& buf, int& n);
	RecordVal* ExtractAttrs(const u_char*& buf, int& n);
	RecordVal* ExtractOptAttrs(const u_char*& buf, int& n);
	Val* ExtractCount(const u_char*& buf, int& n);
	Val* ExtractLongAsDouble(const u_char*& buf, int& n);
	Val* ExtractTime(const u_char*& buf, int& n);
	Val* ExtractInterval(const u_char*& buf, int& n);

	void Event(EventHandlerPtr f, Val* request, int status, Val* reply);
};

class UDP_NFS : public UDP_RPC {
public:
	UDP_NFS(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct udphdr* up)
	: UDP_RPC(new NFS_Interp(this), s, k, t, id, up)
		{ }
};

class NFS_Conn : public TCP_Connection {
public:
	NFS_Conn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	~NFS_Conn();
	void Done();

protected:
	void BuildEndpoints();

	RPC_Interpreter* interp;
	TCP_Contents_RPC* orig_rpc;
	TCP_Contents_RPC* resp_rpc;
};

#endif
