// $Id: NTP.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef ntp_h
#define ntp_h

#include "UDP.h"


// The following are from the tcpdump distribution, credited there
// to the U of MD implementation.

#define JAN_1970	2208988800.0	/* 1970 - 1900 in seconds */

struct l_fixedpt {
	unsigned int int_part;
	unsigned int fraction;
};

struct s_fixedpt {
	unsigned short int_part;
	unsigned short fraction;
};

struct ntpdata {
	unsigned char status;	/* status of local clock and leap info */
	unsigned char stratum;	/* Stratum level */
	unsigned char ppoll;	/* poll value */
	int precision:8;
	struct s_fixedpt distance;
	struct s_fixedpt dispersion;
	unsigned int refid;
	struct l_fixedpt reftime;
	struct l_fixedpt org;
	struct l_fixedpt rec;
	struct l_fixedpt xmt;
};

class NTP_Session : public UDP_Connection {
public:
	NTP_Session(NetSessions* s, HashKey* k, double t, const ConnID* id,
		const struct udphdr* up);
	void Done();

protected:
	int Request(double t, const u_char* data, int len);
	int Reply(double t, const u_char* data, int len);

	// NTP is a unidirectional protocol, so no notion of "requests"
	// as separate from "replies".
	void Message(const u_char* data, int len);

	double ShortFloat(struct s_fixedpt fp);
	double LongFloat(struct l_fixedpt fp);
	double ConvertToDouble(unsigned int int_part, unsigned int fraction,
				double frac_base);

	friend class ConnectionTimer;
	void ExpireTimer(double t);
};

#endif
