// $Id: Net.h,v 1.7 2005/02/09 08:19:03 vern Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2000, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef net_h
#define net_h

#include "net_util.h"
#include "BPF_Program.h"
#include "List.h"
#include "PktSrc.h"
#include "Func.h"
#include "RemoteSerializer.h"

extern void net_init(name_list& interfaces, name_list& readfiles,
		const char* writefile, const char* transformed_writefile,
		const char* filter, const char* secondary_filter,
		int do_watchdog);
extern void net_run();
extern void net_get_final_stats();
extern void net_finish(int drain_events);
extern void net_delete();	// Reclaim all memory, etc.
extern int net_packet_match(BPF_Program* fp, const u_char* pkt,
			    u_int len, u_int caplen);

// Whether we're reading live traffic.
extern int reading_live;

// Same but for reading from traces instead.  We have two separate
// variables because it's possible that neither is true, and we're
// instead just running timers (per the variable after this one).
extern int reading_traces;

// True if we have timers scheduled for the future on which we need
// to wait.  "Need to wait" here means that we're running live (though
// perhaps not reading_live, but just running in real-time) as opposed
// to reading a trace (in which case we don't want to wait in real-time
// on future timers).
extern int have_pending_timers;

// Pcap filter supplied by the user on the command line (if any).
extern char* user_pcap_filter;

// When we started processing the current packet and corresponding event
// queue.
extern double processing_start_time;

// True if we're a in the process of cleaning-up just before termination.
extern bool terminating;

// True if the remote serializer is to be activated.
extern bool using_communication;

extern const struct pcap_pkthdr* current_hdr;
extern const u_char* current_pkt;
extern int current_dispatched;
extern PktSrc* current_pktsrc;

declare(PList,PktSrc);
extern PList(PktSrc) pkt_srcs;

extern PktDumper* pkt_dumper;	// where to save packets
extern PktDumper* pkt_transformed_dumper;

extern char* writefile;

#endif
