// $Id: NetVar.cc,v 1.17 2005/08/23 21:40:04 vern Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "config.h"

#include "Var.h"
#include "NetVar.h"

RecordType* conn_id;
RecordType* endpoint;
RecordType* endpoint_stats;
RecordType* connection_type;
RecordType* icmp_conn;
RecordType* icmp_context;
RecordType* SYN_packet;
RecordType* signature_state;
EnumType* transport_proto;

RecordType* net_stats;

int watchdog_interval;
double heartbeat_interval;

int max_timer_expires;

int ignore_checksums;
int partial_connection_ok;
int tcp_SYN_ack_ok;
int tcp_match_undelivered;

int encap_hdr_size;
int tunnel_port;

double frag_timeout;

double tcp_SYN_timeout;
double tcp_session_timer;
double tcp_connection_linger;
double tcp_attempt_delay;
double tcp_close_delay;
double tcp_reset_delay;
double tcp_partial_close_delay;

int ssl_compare_cipherspecs;
int ssl_analyze_certificates;
int ssl_store_certificates;
int ssl_verify_certificates;
int ssl_store_key_material;
int ssl_max_cipherspec_size;
StringVal* ssl_store_cert_path;
StringVal* x509_trusted_cert_path;
TableType* cipher_suites_list;
RecordType* x509_type;

double non_analyzed_lifetime;
double tcp_inactivity_timeout;
double udp_inactivity_timeout;
double icmp_inactivity_timeout;

int tcp_storm_thresh;
double tcp_storm_interarrival_thresh;

TableVal* tcp_reassembler_ports_orig;
TableVal* tcp_reassembler_ports_resp;

TableVal* tcp_content_delivery_ports_orig;
TableVal* tcp_content_delivery_ports_resp;

double dns_session_timeout;
double ntp_session_timeout;
double rpc_timeout;

ListVal* skip_authentication;
ListVal* direct_login_prompts;
ListVal* login_prompts;
ListVal* login_non_failure_msgs;
ListVal* login_failure_msgs;
ListVal* login_success_msgs;
ListVal* login_timeouts;

int mime_segment_length;
int mime_segment_overlap_length;
RecordType* mime_header_rec;
TableType* mime_header_list;

int http_entity_data_delivery_size;
RecordType* http_stats_rec;
RecordType* http_message_stat;
int truncate_http_URI;

int pm_request;
RecordType* pm_mapping;
TableType* pm_mappings;
RecordType* pm_port_request;
RecordType* pm_callit_request;

RecordType* nfs3_attrs;
RecordType* nfs3_lookup_args;
RecordType* nfs3_lookup_reply;
RecordType* nfs3_fsstat;

RecordType* ntp_msg;

TableVal* samba_cmds;

RecordType* dns_msg;
RecordType* dns_answer;
RecordType* dns_soa;
RecordType* dns_edns_additional;
RecordType* dns_tsig_additional;
TableVal* dns_skip_auth;
TableVal* dns_skip_addl;
int dns_max_queries;

double stp_delta;
double stp_idle_min;

EnumType* dce_rpc_ptype;

double interconn_min_interarrival;
double interconn_max_interarrival;
int interconn_max_keystroke_pkt_size;
int interconn_default_pkt_size;
double interconn_stat_period;
double interconn_stat_backoff;
RecordType* interconn_endp_stats;

double backdoor_stat_period;
double backdoor_stat_backoff;

RecordType* backdoor_endp_stats;

RecordType* software;
RecordType* software_version;
RecordType* OS_version;
EnumType* OS_version_inference;
TableVal* generate_OS_version_event;

double table_expire_interval;
double table_expire_delay;
int table_expire_size;

RecordType* packet_type;

double packet_sort_window;

double connection_status_update_interval;

StringVal* state_dir;
double state_write_delay;

int orig_addr_anonymization, resp_addr_anonymization;
int other_addr_anonymization;
TableVal* preserve_orig_addr;
TableVal* preserve_resp_addr;
TableVal* preserve_other_addr;

double log_rotate_interval;
double log_max_size;
RecordType* rotate_info;
StringVal* log_encryption_key;

StringVal* peer_description;
RecordType* peer;

StringVal* ssl_ca_certificate;
StringVal* ssl_private_key;
StringVal* ssl_passphrase;

StringVal* x509_crl_file;
TableType* x509_extension;
TableType* SSL_sessionID;

Val* profiling_file;
double profiling_interval;
int expensive_profiling_multiple;
int segment_profiling;
int pkt_profile_mode;
double pkt_profile_freq;
Val* pkt_profile_file;

int packet_filter_default;

int sig_max_group_size;

int enable_syslog;

int use_connection_compressor;
int cc_handle_resets;
int cc_handle_only_syns;
int cc_instantiate_on_data;

#include "const.bif.netvar_def"
#include "event.bif.netvar_def"


void init_general_global_var()
	{
	table_expire_interval = opt_internal_double("table_expire_interval");
	table_expire_delay = opt_internal_double("table_expire_delay");
	table_expire_size = opt_internal_int("table_expire_size");

	state_dir = internal_val("state_dir")->AsStringVal();
	state_write_delay = opt_internal_double("state_write_delay");

	log_rotate_interval = opt_internal_double("log_rotate_interval");
	log_max_size = opt_internal_double("log_max_size");
	rotate_info = internal_type("rotate_info")->AsRecordType();
	log_encryption_key = opt_internal_string("log_encryption_key");

	peer_description =
		internal_val("peer_description")->AsStringVal();
	peer = internal_type("event_peer")->AsRecordType();

	ssl_ca_certificate = internal_val("ssl_ca_certificate")->AsStringVal();
	ssl_private_key = internal_val("ssl_private_key")->AsStringVal();
	ssl_passphrase = internal_val("ssl_passphrase")->AsStringVal();

	packet_filter_default = opt_internal_int("packet_filter_default");
	
	sig_max_group_size = opt_internal_int("sig_max_group_size");
	enable_syslog = opt_internal_int("enable_syslog");
	}

void init_net_var()
	{
#include "const.bif.netvar_init"
#include "event.bif.netvar_init"

	conn_id = internal_type("conn_id")->AsRecordType();
	endpoint = internal_type("endpoint")->AsRecordType();
	endpoint_stats = internal_type("endpoint_stats")->AsRecordType();
	connection_type = internal_type("connection")->AsRecordType();
	icmp_conn = internal_type("icmp_conn")->AsRecordType();
	icmp_context = internal_type("icmp_context")->AsRecordType();
	signature_state = internal_type("signature_state")->AsRecordType();
	SYN_packet = internal_type("SYN_packet")->AsRecordType();
	transport_proto = internal_type("transport_proto")->AsEnumType();

	ignore_checksums = opt_internal_int("ignore_checksums");
	partial_connection_ok = opt_internal_int("partial_connection_ok");
	tcp_SYN_ack_ok = opt_internal_int("tcp_SYN_ack_ok");
	tcp_match_undelivered = opt_internal_int("tcp_match_undelivered");

	encap_hdr_size = opt_internal_int("encap_hdr_size");

	tunnel_port = opt_internal_int("tunnel_port");
	// If it's a UDP port, normalize it.
	tunnel_port &= ~UDP_PORT_MASK;

	frag_timeout = opt_internal_double("frag_timeout");

	tcp_SYN_timeout = opt_internal_double("tcp_SYN_timeout");
	tcp_session_timer = opt_internal_double("tcp_session_timer");
	tcp_connection_linger = opt_internal_double("tcp_connection_linger");
	tcp_attempt_delay = opt_internal_double("tcp_attempt_delay");
	tcp_close_delay = opt_internal_double("tcp_close_delay");
	tcp_reset_delay = opt_internal_double("tcp_reset_delay");
	tcp_partial_close_delay = opt_internal_double("tcp_partial_close_delay");

	ssl_compare_cipherspecs  = opt_internal_int("ssl_compare_cipherspecs");
	ssl_analyze_certificates = opt_internal_int("ssl_analyze_certificates");
	ssl_store_certificates   = opt_internal_int("ssl_store_certificates");
	ssl_verify_certificates  = opt_internal_int("ssl_verify_certificates");
	ssl_store_key_material = opt_internal_int("ssl_store_key_material");
	ssl_max_cipherspec_size  = opt_internal_int("ssl_max_cipherspec_size");

	x509_trusted_cert_path = opt_internal_string("X509_trusted_cert_path");
	ssl_store_cert_path = opt_internal_string("ssl_store_cert_path");
	x509_type = internal_type("X509")->AsRecordType();
	cipher_suites_list = internal_type("cipher_suites_list")->AsTableType();
	x509_crl_file = opt_internal_string("X509_crl_file");
	x509_extension = internal_type("X509_extension")->AsTableType();
	SSL_sessionID = internal_type("SSL_sessionID")->AsTableType();

	non_analyzed_lifetime = opt_internal_double("non_analyzed_lifetime");
	tcp_inactivity_timeout = opt_internal_double("tcp_inactivity_timeout");
	udp_inactivity_timeout = opt_internal_double("udp_inactivity_timeout");
	icmp_inactivity_timeout = opt_internal_double("icmp_inactivity_timeout");

	tcp_storm_thresh = opt_internal_int("tcp_storm_thresh");
	tcp_storm_interarrival_thresh =
		opt_internal_double("tcp_storm_interarrival_thresh");

	tcp_reassembler_ports_orig =
		internal_val("tcp_reassembler_ports_orig")->AsTableVal();
	tcp_reassembler_ports_resp =
		internal_val("tcp_reassembler_ports_resp")->AsTableVal();

	tcp_content_delivery_ports_orig =
		internal_val("tcp_content_delivery_ports_orig")->AsTableVal();
	tcp_content_delivery_ports_resp =
		internal_val("tcp_content_delivery_ports_resp")->AsTableVal();

	dns_session_timeout = opt_internal_double("dns_session_timeout");
	ntp_session_timeout = opt_internal_double("ntp_session_timeout");
	rpc_timeout = opt_internal_double("rpc_timeout");

	net_stats = internal_type("net_stats")->AsRecordType();

	watchdog_interval = int(opt_internal_double("watchdog_interval"));
	heartbeat_interval = opt_internal_double("heartbeat_interval");

	max_timer_expires = opt_internal_int("max_timer_expires");

	skip_authentication = internal_list_val("skip_authentication");
	direct_login_prompts = internal_list_val("direct_login_prompts");
	login_prompts = internal_list_val("login_prompts");
	login_non_failure_msgs = internal_list_val("login_non_failure_msgs");
	login_failure_msgs = internal_list_val("login_failure_msgs");
	login_success_msgs = internal_list_val("login_success_msgs");
	login_timeouts = internal_list_val("login_timeouts");

	mime_segment_length = opt_internal_int("mime_segment_length");
	mime_segment_overlap_length = opt_internal_int("mime_segment_overlap_length");
	mime_header_rec = internal_type("mime_header_rec")->AsRecordType();
	mime_header_list = internal_type("mime_header_list")->AsTableType();

	http_entity_data_delivery_size = opt_internal_int("http_entity_data_delivery_size");
	http_stats_rec = internal_type("http_stats_rec")->AsRecordType();
	http_message_stat = internal_type("http_message_stat")->AsRecordType();
	truncate_http_URI = opt_internal_int("truncate_http_URI");

	pm_request = pm_request_null || pm_request_set ||
		pm_request_unset || pm_request_getport ||
		pm_request_dump || pm_request_callit ||
		pm_attempt_null || pm_attempt_set ||
		pm_attempt_unset || pm_attempt_getport ||
		pm_attempt_dump || pm_attempt_callit ||
		pm_bad_port;

	pm_mapping = internal_type("pm_mapping")->AsRecordType();
	pm_mappings = internal_type("pm_mappings")->AsTableType();
	pm_port_request = internal_type("pm_port_request")->AsRecordType();
	pm_callit_request = internal_type("pm_callit_request")->AsRecordType();

	nfs3_attrs = internal_type("nfs3_attrs")->AsRecordType();
	nfs3_lookup_args = internal_type("nfs3_lookup_args")->AsRecordType();
	nfs3_lookup_reply = internal_type("nfs3_lookup_reply")->AsRecordType();
	nfs3_fsstat = internal_type("nfs3_fsstat")->AsRecordType();

	ntp_msg = internal_type("ntp_msg")->AsRecordType();

	samba_cmds = internal_val("samba_cmds")->AsTableVal();

	dns_msg = internal_type("dns_msg")->AsRecordType();
	dns_answer = internal_type("dns_answer")->AsRecordType();
	dns_soa = internal_type("dns_soa")->AsRecordType();
	dns_edns_additional =
		internal_type("dns_edns_additional")->AsRecordType();
	dns_tsig_additional =
		internal_type("dns_tsig_additional")->AsRecordType();

	dns_skip_auth = internal_val("dns_skip_auth")->AsTableVal();
	dns_skip_addl = internal_val("dns_skip_addl")->AsTableVal();
	dns_max_queries = opt_internal_int("dns_max_queries");

	stp_delta = opt_internal_double("stp_delta");
	stp_idle_min = opt_internal_double("stp_idle_min");

	dce_rpc_ptype = internal_type("dce_rpc_ptype")->AsEnumType();

	interconn_min_interarrival = opt_internal_double("interconn_min_interarrival");
	interconn_max_interarrival = opt_internal_double("interconn_max_interarrival");
	interconn_max_keystroke_pkt_size = opt_internal_int("interconn_max_keystroke_pkt_size");
	interconn_default_pkt_size = opt_internal_int("interconn_default_pkt_size");
	interconn_stat_period = opt_internal_double("interconn_stat_period");
	interconn_stat_backoff = opt_internal_double("interconn_stat_backoff");
	interconn_endp_stats = internal_type("interconn_endp_stats")->AsRecordType();

	backdoor_stat_period = opt_internal_double("backdoor_stat_period");
	backdoor_stat_backoff = opt_internal_double("backdoor_stat_backoff");
	backdoor_endp_stats = internal_type("backdoor_endp_stats")->AsRecordType();

	software = internal_type("software")->AsRecordType();
	software_version = internal_type("software_version")->AsRecordType();
	OS_version = internal_type("OS_version")->AsRecordType();
	OS_version_inference = internal_type("OS_version_inference")->AsEnumType();
	generate_OS_version_event =
		opt_internal_table("generate_OS_version_event");

	packet_type = internal_type("packet")->AsRecordType();

	packet_sort_window = opt_internal_double("packet_sort_window");

	orig_addr_anonymization = opt_internal_int("orig_addr_anonymization");
	resp_addr_anonymization = opt_internal_int("resp_addr_anonymization");
	other_addr_anonymization = opt_internal_int("other_addr_anonymization");

	preserve_orig_addr = opt_internal_table("preserve_orig_addr");
	preserve_resp_addr = opt_internal_table("preserve_resp_addr");
	preserve_other_addr = opt_internal_table("preserve_other_addr");

	connection_status_update_interval =
		opt_internal_double("connection_status_update_interval");

	profiling_file = internal_val("profiling_file");
	expensive_profiling_multiple =
		opt_internal_int("expensive_profiling_multiple");
	profiling_interval = opt_internal_double("profiling_interval");
	segment_profiling = opt_internal_int("segment_profiling");

	pkt_profile_mode = opt_internal_int("pkt_profile_mode");
	pkt_profile_freq = opt_internal_double("pkt_profile_freq");
	pkt_profile_file = opt_internal_val("pkt_profile_file");

	use_connection_compressor =
		opt_internal_int("use_connection_compressor");
	cc_handle_resets = opt_internal_int("cc_handle_resets");
	cc_handle_only_syns = opt_internal_int("cc_handle_only_syns");
	cc_instantiate_on_data = opt_internal_int("cc_instantiate_on_data");
	}
