// $Id: NetVar.h,v 1.16 2005/08/23 21:40:04 vern Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef netvar_h
#define netvar_h

#include "Val.h"
#include "Func.h"
#include "EventRegistry.h"
#include "Stats.h"

extern RecordType* conn_id;
extern RecordType* endpoint;
extern RecordType* endpoint_stats;
extern RecordType* connection_type;
extern RecordType* icmp_conn;
extern RecordType* icmp_context;
extern RecordType* signature_state;
extern RecordType* SYN_packet;
extern EnumType* transport_proto;

extern RecordType* net_stats;

extern int watchdog_interval;
extern double heartbeat_interval;

extern int max_timer_expires;

extern int ignore_checksums;
extern int partial_connection_ok;
extern int tcp_SYN_ack_ok;
extern int tcp_match_undelivered;

extern int encap_hdr_size;
extern int tunnel_port;

extern double frag_timeout;

extern double tcp_SYN_timeout;
extern double tcp_session_timer;
extern double tcp_connection_linger;
extern double tcp_attempt_delay;
extern double tcp_close_delay;
extern double tcp_partial_close_delay;
extern double tcp_reset_delay;

// see policy/ssl.bro for details
extern int ssl_compare_cipherspecs;
extern int ssl_analyze_certificates;
extern int ssl_store_certificates;
extern int ssl_verify_certificates;
extern int ssl_store_key_material;
extern int ssl_max_cipherspec_size;
extern StringVal* ssl_store_cert_path;
extern StringVal* x509_trusted_cert_path;
extern TableType* cipher_suites_list;
extern RecordType* x509_type;
extern StringVal* x509_crl_file;
extern TableType* x509_extension;
extern TableType* SSL_sessionID;

extern double non_analyzed_lifetime;
extern double tcp_inactivity_timeout;
extern double udp_inactivity_timeout;
extern double icmp_inactivity_timeout;

extern int tcp_storm_thresh;
extern double tcp_storm_interarrival_thresh;

extern TableVal* tcp_reassembler_ports_orig;
extern TableVal* tcp_reassembler_ports_resp;

extern TableVal* tcp_content_delivery_ports_orig;
extern TableVal* tcp_content_delivery_ports_resp;

extern double dns_session_timeout;
extern double ntp_session_timeout;
extern double rpc_timeout;

extern ListVal* skip_authentication;
extern ListVal* direct_login_prompts;
extern ListVal* login_prompts;
extern ListVal* login_non_failure_msgs;
extern ListVal* login_failure_msgs;
extern ListVal* login_success_msgs;
extern ListVal* login_timeouts;

extern int mime_segment_length;
extern int mime_segment_overlap_length;
extern RecordType* mime_header_rec;
extern TableType* mime_header_list;

extern int http_entity_data_delivery_size;
extern RecordType* http_stats_rec;
extern RecordType* http_message_stat;
extern int truncate_http_URI;

extern int pm_request;
extern RecordType* pm_mapping;
extern TableType* pm_mappings;
extern RecordType* pm_port_request;
extern RecordType* pm_callit_request;

extern RecordType* nfs3_attrs;
extern RecordType* nfs3_lookup_args;
extern RecordType* nfs3_lookup_reply;
extern RecordType* nfs3_fsstat;

extern RecordType* ntp_msg;

extern TableVal* samba_cmds;

extern RecordType* dns_msg;
extern RecordType* dns_answer;
extern RecordType* dns_soa;
extern RecordType* dns_edns_additional;
extern RecordType* dns_tsig_additional;
extern TableVal* dns_skip_auth;
extern TableVal* dns_skip_addl;
extern int dns_max_queries;

extern double stp_delta;
extern double stp_idle_min;

extern EnumType* dce_rpc_ptype;

extern double interconn_min_interarrival;
extern double interconn_max_interarrival;
extern int interconn_max_keystroke_pkt_size;
extern int interconn_default_pkt_size;
extern double interconn_stat_period;
extern double interconn_stat_backoff;
extern RecordType* interconn_endp_stats;

extern double backdoor_stat_period;
extern double backdoor_stat_backoff;

extern RecordType* backdoor_endp_stats;

extern RecordType* software;
extern RecordType* software_version;
extern RecordType* OS_version;
extern EnumType* OS_version_inference;
extern TableVal* generate_OS_version_event;

extern double table_expire_interval;
extern double table_expire_delay;
extern int table_expire_size;

extern RecordType* packet_type;

extern double packet_sort_window;

extern int orig_addr_anonymization, resp_addr_anonymization;
extern int other_addr_anonymization;
extern TableVal* preserve_orig_addr;
extern TableVal* preserve_resp_addr;
extern TableVal* preserve_other_addr;

extern double connection_status_update_interval;

extern StringVal* state_dir;
extern double state_write_delay;

extern double log_rotate_interval;
extern double log_max_size;
extern RecordType* rotate_info;
extern StringVal* log_encryption_key;

extern StringVal* peer_description;
extern RecordType* peer;

extern StringVal* ssl_ca_certificate;
extern StringVal* ssl_private_key;
extern StringVal* ssl_passphrase;

extern Val* profiling_file;
extern double profiling_interval;
extern int expensive_profiling_multiple;

extern int segment_profiling;
extern int pkt_profile_mode;
extern double pkt_profile_freq;
extern Val* pkt_profile_file;

extern int packet_filter_default;

extern int sig_max_group_size;

extern int enable_syslog;

extern int use_connection_compressor;
extern int cc_handle_resets;
extern int cc_handle_only_syns;
extern int cc_instantiate_on_data;

// Initializes globals that don't pertain to network/event analysis.
extern void init_general_global_var();

extern void init_net_var();

#include "const.bif.netvar_h"
#include "event.bif.netvar_h"

#endif
