// $Id: Portmap.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef portmap_h
#define portmap_h

#include "RPC.h"

class PortmapperInterp : public RPC_Interpreter {
public:
	PortmapperInterp(Connection* arg_conn) : RPC_Interpreter(arg_conn) { }

protected:
	int RPC_BuildCall(RPC_CallInfo* c, const u_char*& buf, int& n);
	int RPC_BuildReply(const RPC_CallInfo* c, int success,
				const u_char*& buf, int& n,
				EventHandlerPtr& event, Val*& reply);
	uint32 CheckPort(uint32 port);

	void Event(EventHandlerPtr f, Val* request, int status, Val* reply);

	Val* ExtractMapping(const u_char*& buf, int& len);
	Val* ExtractPortRequest(const u_char*& buf, int& len);
	Val* ExtractCallItRequest(const u_char*& buf, int& len);
};

class UDP_Portmapper : public UDP_RPC {
public:
	UDP_Portmapper(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct udphdr* up)
	: UDP_RPC(new PortmapperInterp(this), s, k, t, id, up)
		{ }
};

class PortmapperConn : public TCP_Connection {
public:
	PortmapperConn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	~PortmapperConn();
	void Done();

protected:
	void BuildEndpoints();

	RPC_Interpreter* interp;
	TCP_Contents_RPC* orig_rpc;
	TCP_Contents_RPC* resp_rpc;
};

#endif
