// $Id: RSH.cc,v 1.2 2004/11/02 08:13:55 vern Exp $

// Copyright (c) 1999, 2001, 2002, 2004
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "config.h"

#include "NetVar.h"
#include "Event.h"
#include "RSH.h"


// FIXME: this code should probably be merged with Rlogin.cc.

RshEndpoint::RshEndpoint(TCP_Endpoint* arg_endp)
: TCP_ContentLine(arg_endp, 0, 0)
	{
	if ( IsOrig() )
		state = save_state = RSH_FIRST_NULL;
	else
		state = RSH_LINE_MODE;

	num_bytes_to_scan = 0;
	peer = 0;
	}

RshEndpoint::~RshEndpoint()
	{
	}

void RshEndpoint::DoDeliver(int seq, int len, u_char* data)
	{
	for ( ; len > 0; --len, ++data )
		{
		if ( offset >= buf_len )
			Init(buf_len * 2);

		unsigned int c = data[0];

		switch ( state ) {
		case RSH_FIRST_NULL:
			if ( endp->state == TCP_PARTIAL ||
			     // We can be in closed if the data's due to
			     // a dataful FIN being the first thing we see.
			     endp->state == TCP_CLOSED )
				{
				state = RSH_UNKNOWN;
				++len, --data;	// put back c and reprocess
				continue;
				}

			if ( c >= '0' && c <= '9' )
                                ; // skip stderr port number
			else if ( c == '\0' )
				state = RSH_CLIENT_USER_NAME;
			else
				BadProlog();

			break;

		case RSH_CLIENT_USER_NAME:
		case RSH_SERVER_USER_NAME:
			buf[offset++] = c;
			if ( c == '\0' )
				{
				if ( state == RSH_CLIENT_USER_NAME )
					{
					AsRshConn()->ClientUserName(buf);
					state = RSH_SERVER_USER_NAME;
					}

				else if ( state == RSH_SERVER_USER_NAME &&
					  offset > 1 )
					{
					AsRshConn()->ServerUserName(buf);
					save_state = state;
					state = RSH_LINE_MODE;
					}

				offset = 0;
				}
			break;

		case RSH_LINE_MODE:
		case RSH_UNKNOWN:
		case RSH_PRESUMED_REJECTED:
			if ( state == RSH_LINE_MODE &&
			     peer->RshState() == RSH_PRESUMED_REJECTED )
				{
				Conn()->Weird("rsh_text_after_rejected");
				state = RSH_UNKNOWN;
				}

			if ( c == '\n' || c == '\r' )
				{ // CR or LF (RFC 1282)
				if ( c == '\n' && last_char == '\r' )
					// Compress CRLF to just 1 termination.
					;
				else
					{
					buf[offset] = '\0';
					AsRshConn()->NewLine(this, offset, buf,
							     save_state);
					save_state = RSH_LINE_MODE;
					offset = 0;
					break;
					}
				}

			if ( c == '\0' )
				{
				buf[offset] = '\0';
				AsRshConn()->NewLine(this, offset, buf,
						     save_state);
				save_state = RSH_LINE_MODE;
				offset = 0;
				break;
				}

			else
				buf[offset++] = c;

			last_char = c;
			break;

		default:
			internal_error("bad state in RshEndpoint::DoDeliver");
			break;
		}
		}
	}

void RshEndpoint::BadProlog()
	{
	Conn()->Weird("bad_rsh_prolog");
	state = RSH_UNKNOWN;
	}

RshConn::RshConn(NetSessions* s, HashKey* k, double t, const ConnID* id,
		const struct tcphdr* tp)
: LoginConn(s, k, t, id, tp)
	{
	}

void RshConn::BuildEndpoints()
	{
	RshEndpoint* o_rsh = new RshEndpoint(orig);
	RshEndpoint* r_rsh = new RshEndpoint(resp);

	o_rsh->SetPeer(r_rsh);
	r_rsh->SetPeer(o_rsh);

	orig->AddContentsProcessor(o_rsh);
	resp->AddContentsProcessor(r_rsh);
	}

void RshConn::NewLine(TCP_ContentLine* s, int length, const char* line,
		      rsh_state save_state)
        {
	val_list* vl = new val_list;

	line = skip_whitespace(line);
	vl->append(BuildConnVal());
	vl->append(client_name ? client_name->Ref() : new StringVal("<none>"));
	vl->append(username ? username->Ref() : new StringVal("<none>"));
	vl->append(new StringVal(line));

        if ( s->IsOrig() && rsh_request )
		{
		if ( save_state == RSH_SERVER_USER_NAME )
			// First input
			vl->append(new Val(true, TYPE_BOOL));
		else
			vl->append(new Val(false, TYPE_BOOL));

		ConnectionEvent(rsh_request, vl);
		}

	else if ( rsh_reply )
		ConnectionEvent(rsh_reply, vl);
	}

void RshConn::ClientUserName(const char* s)
	{
	if ( client_name )
		internal_error("multiple rsh client names");

	client_name = new StringVal(s);
	}

void RshConn::ServerUserName(const char* s)
	{
	if ( username )
		internal_error("multiple rsh initial client names");

	username = new StringVal(s);
	}
