// $Id: RSH.h,v 1.1 2004/11/02 06:48:03 vern Exp $

// Copyright (c) 1999, 2001, 2002, 2004
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef rsh_h
#define rsh_h

#include "Login.h"

typedef enum {
	RSH_FIRST_NULL,		// waiting to see first NUL
	RSH_CLIENT_USER_NAME,	// scanning client user name up to NUL
	RSH_SERVER_USER_NAME,	// scanning server user name up to NUL
	RSH_INITIAL_CMD,	// scanning initial command up to NUL

	RSH_LINE_MODE,		// switch to line-oriented processing

	RSH_PRESUMED_REJECTED,	// apparently server said No Way

	RSH_UNKNOWN,	// we don't know what state we're in
} rsh_state;

class RshConn;

class RshEndpoint : public TCP_ContentLine {
public:
	RshEndpoint(TCP_Endpoint* endp);
	~RshEndpoint();

	rsh_state RshState() const	{ return state; }

	void SetPeer(RshEndpoint* arg_peer)	{ peer = arg_peer; }

protected:
	void DoDeliver(int seq, int len, u_char* data);
	void BadProlog();

	RshConn* AsRshConn()	{ return (RshConn*) Conn(); }

	RshEndpoint* peer;
	rsh_state state, save_state;
	int num_bytes_to_scan;
};

class RshConn : public LoginConn {
public:
	RshConn(NetSessions* s, HashKey* k, double t, const ConnID* id,
		const struct tcphdr* tp);

	void NewLine(TCP_ContentLine* sender, int length, const char* line,
		     rsh_state save_state);

	void ClientUserName(const char* s);
	void ServerUserName(const char* s);

protected:
	void BuildEndpoints();
};

#endif
