// $Id: RuleAction.cc,v 1.1 2004/07/14 20:15:40 jason Exp $

#include "config.h"

#include "RuleAction.h"
#include "RuleMatcher.h"
#include "Conn.h"
#include "Event.h"
#include "NetVar.h"

void RuleActionEvent::DoAction(const Rule* parent, RuleEndpointState* state,
				const u_char* data, int len)
	{
	if ( signature_match )
		{
		val_list* vl = new val_list;
		vl->append(rule_matcher->BuildRuleStateValue(parent, state));
		vl->append(new StringVal(msg));

		if ( data )
			vl->append(new StringVal(len, (const char*)data));
		else
			vl->append(new StringVal(""));

		mgr.QueueEvent(signature_match, vl);
		}
	}

void RuleActionEvent::PrintDebug()
	{
	fprintf(stderr, "	RuleActionEvent: |%s|\n", msg);
	}
