// $Id: RuleAction.h,v 1.1 2004/07/14 20:15:40 jason Exp $

#ifndef ruleaction_h
#define ruleaction_h

#include "BroString.h"
#include "List.h"
#include "util.h"

class Rule;
class RuleEndpointState;

// Base class of all rule actions.
class RuleAction {
public:
	RuleAction()	{ }
	virtual ~RuleAction()	{ }

	virtual void DoAction(const Rule* parent, RuleEndpointState* state,
				const u_char* data, int len) = 0;
	virtual void PrintDebug() = 0;
};

// Implements the "event" keyword.
class RuleActionEvent : public RuleAction {
public:
	RuleActionEvent(const char* arg_msg)	{ msg = copy_string(arg_msg); }
	virtual ~RuleActionEvent()	{ delete [] msg; }

	virtual void DoAction(const Rule* parent, RuleEndpointState* state,
				const u_char* data, int len);

	virtual void PrintDebug();

private:
	const char* msg;
};

#endif
