// $Id: SMB.h,v 1.1 2004/07/14 20:15:40 jason Exp $
//
// Copyright (c) 1996-2004
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef smb_h
#define smb_h

// SMB (CIFS) analyzer.
// Reference: http://www.snia.org/tech_activities/CIFS/CIFS-TR-1p00_FINAL.pdf

#include "TCP.h"
#include "TCP_Contents.h"
#include "DCE_RPC.h"

enum IPC_named_pipe {
	IPC_NONE,
	IPC_LOCATOR,
	IPC_EPMAPPER,
	IPC_SAMR,	// Security Account Manager
};

class SMB_Session {
public:
	SMB_Session(Connection* conn);
	~SMB_Session();

	void Deliver(int is_orig, int len, const u_char* msg);

protected:
	int ParseTreeConnectAndx(int len, const u_char* msg);
	int ParseNtCreateAndx(int len, const u_char* msg);
	int ParseTransaction(int is_orig, int cmd, int len, const u_char* msg);
	int ParseReadAndx(int is_orig, int len, const u_char* msg);
	int ParseWriteAndx(int is_orig, int len, const u_char* msg);

	int GetWord(int len, const u_char* msg, int off, uint16* w);
	int Get_SMB_DataPortion(int len, const u_char* msg,
				uint16* byte_count, const u_char** data);
	BroString* ExtractString(const u_char* msg, int& len,
				const u_char*& data);
	int LooksLikeRPC(int len, const u_char* msg, uint16 data_count,
				uint16 data_off);

	void Weird(const char* msg);

	Connection* conn;
	DCE_RPC_Session* dce_rpc_session;
	enum IPC_named_pipe IPC_pipe;
	int is_IPC;
	uint16 transaction_subcmd;
	StringVal* transaction_name;
};

class TCP_Contents_SMB : public TCP_Contents {
public:
	TCP_Contents_SMB(TCP_Endpoint* endp, SMB_Session* smb_session);
	~TCP_Contents_SMB();

protected:
	void InitMsgBuf();

	void Deliver(int seq, int len, u_char* data);
	void DeliverSMB(int len, const u_char* data);

	SMB_Session* smb_session;
	u_char dshdr[4];
	u_char* msg_buf;
	int msg_len;
	int buf_n;	// number of bytes in msg_buf
	int buf_len;	// size off msg_buf
};

class SMB_TCP_Conn : public TCP_Connection {
public:
	SMB_TCP_Conn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	~SMB_TCP_Conn();

protected:
	void BuildEndpoints();

	SMB_Session* smb_session;
	TCP_Contents_SMB* o_smb;
	TCP_Contents_SMB* r_smb;
};

#endif
