// $Id: SMTP.h,v 1.2 2005/01/23 21:45:09 vern Exp $
//
// Copyright (c) 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef smtp_h
#define smtp_h

#include <list>
using namespace std;

#include "TCP.h"
#include "MIME.h"


#undef SMTP_CMD_DEF
#define SMTP_CMD_DEF(cmd)	SMTP_CMD_##cmd,

typedef enum {
#include "SMTP_cmd.def"
} SMTP_Cmd;

// State is updated on every SMTP reply.
typedef enum {
	SMTP_CONNECTED,		// 0: before the opening message
	SMTP_INITIATED,		// 1: after opening message 220, EHLO/HELO expected
	SMTP_NOT_AVAILABLE,	// 2: after opening message 554, etc.
	SMTP_READY,		// 3: after EHLO/HELO and reply 250
	SMTP_MAIL_OK,		// 4: after MAIL/SEND/SOML/SAML and 250, RCPT expected
	SMTP_RCPT_OK,		// 5: after one successful RCPT, DATA or more RCPT expected
	SMTP_IN_DATA,		// 6: after DATA
	SMTP_AFTER_DATA,	// 7: after . and before reply
	SMTP_IN_AUTH,		// 8: after AUTH and 334
	SMTP_IN_TLS,		// 9: after STARTTLS and 220
	SMTP_QUIT,		// 10: after QUIT
	SMTP_AFTER_GAP,		// 11: after a gap is detected
	SMTP_GAP_RECOVERY,	// 12: after the first reply after a gap
} SMTP_State;


class SMTP_Conn : public TCP_Connection {
public:
	SMTP_Conn(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct tcphdr* tp);
	~SMTP_Conn();
	void Done();
	void ConnectionFinished(int half_finished);

	void NewLine(TCP_ContentLine* sender, int length, const char* line);
	// Detect gaps
	void Undelivered(TCP_Endpoint* sender, int seq, int len);

	void SkipData()	{ skip_data = 1; }	// skip delivery of data lines

	int RewritingTrace()	{ return rewriting_smtp_trace; }

protected:
	void BuildEndpoints();

	void ProcessLine(TCP_ContentLine* s, int length, const char* line);
	void NewCmd(const int cmd_code);
	void NewReply(const int reply_code);
	void ProcessExtension(int ext_len, const char* ext);
	void ProcessData(int length, const char* line);

	void UpdateState(const int cmd_code, const int reply_code);

	void BeginData();
	void EndData();

	int ParseCmd(int cmd_len, const char* cmd);

	void RequestEvent(int cmd_len, const char* cmd, int arg_len, const char* arg);
	void Unexpected(const int is_orig, const char* msg, int detail_len, const char* detail);
	void UnexpectedCommand(const int cmd_code, const int reply_code);
	void UnexpectedReply(const int cmd_code, const int reply_code);

	TCP_Endpoint* sender;
	int expect_sender, expect_recver;
	int state;
	int last_replied_cmd;
	int first_cmd;			// first un-replied SMTP cmd, or -1
	int pending_reply;		// code assoc. w/ multi-line reply, or 0
	int pipelining;			// whether pipelining is supported
	list<int> pending_cmd_q;	// to support pipelining
	int skip_data;			// whether to skip message body
	int orig_record_contents;	// keep the original record_contents
	BroString* line_after_gap;	// last line before the first reply
					// after a gap

	MIME_Mail* mail;
};

#endif
