// $Id: SSLDefines.h,v 1.1 2004/07/14 20:15:40 jason Exp $

// Defines the states and transitions in the ssl-protocol-machine.

#ifndef SSL_DEFINES_H
#define SSL_DEFINES_H

const int SSL3_1_NUM_STATES = 20;
enum SSL3_1_States {
	SSL3_1_STATE_ERROR = 0,
	SSL3_1_STATE_INIT  = 1,
	SSL3_1_STATE_SERVER_HELLO_REQ_SENT = 2,
	SSL3_1_STATE_CLIENT_HELLO_SENT = 3,
	SSL3_1_STATE_SERVER_HELLO_SENT = 4,
	SSL3_1_STATE_SERVER_CERT_SENT = 5,
	SSL3_1_STATE_SERVER_KEY_EXCHANGE_SENT = 6,
	SSL3_1_STATE_SERVER_CERT_REQ_SENT = 7,
	SSL3_1_STATE_SERVER_HELLO_DONE_SENT_A = 8,
	SSL3_1_STATE_SERVER_HELLO_DONE_SENT_B = 9,
	SSL3_1_STATE_CLIENT_KEY_EXCHANGE_SENT_A = 10,
	SSL3_1_STATE_CLIENT_KEY_EXCHANGE_SENT_B = 11,
	SSL3_1_STATE_CLIENT_CERT_SENT = 12,
	SSL3_1_STATE_CLIENT_CERT_VERIFY_SENT = 13,
	SSL3_1_STATE_CLIENT_FIN_SENT_A = 14,
	SSL3_1_STATE_SERVER_FIN_SENT_A = 15,
	SSL3_1_STATE_CLIENT_FIN_SENT_B = 16,
	SSL3_1_STATE_SERVER_FIN_SENT_B = 17,
	SSL3_1_STATE_HS_FIN_A = 18,
	SSL3_1_STATE_HS_FIN_B = 19
};

const int SSL3_1_NUM_TRANS = 11;
enum SSL_3_1_Transitions {
	SSL3_1_TRANS_SERVER_HELLO_REQ = 0,
	SSL3_1_TRANS_CLIENT_HELLO = 1,
	SSL3_1_TRANS_SERVER_HELLO = 2,
	SSL3_1_TRANS_SERVER_CERT = 3,
	SSL3_1_TRANS_SERVER_KEY_EXCHANGE = 4,
	SSL3_1_TRANS_SERVER_CERT_REQ = 5,
	SSL3_1_TRANS_SERVER_HELLO_DONE = 6,
	SSL3_1_TRANS_CLIENT_CERT = 3,
	SSL3_1_TRANS_CLIENT_KEY_EXCHANGE = 7,
	SSL3_1_TRANS_CLIENT_CERT_VERIFY = 8,
	SSL3_1_TRANS_CLIENT_FIN = 9,
	SSL3_1_TRANS_SERVER_FIN = 10
};

#endif
