// $Id: ScriptAnaly.cc,v 1.1 2004/12/06 01:06:22 vern Exp $
//
// Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "Dict.h"
#include "Expr.h"
#include "Traverse.h"
#include "ScriptAnaly.h"

typedef const char cchar;
declare(PDict, cchar);


class FindNoteCallback : public TraversalCallback {
public:
	FindNoteCallback()	{ note_expr = 0; }

	virtual TraversalCode PreExpr(const Expr* e);

	Expr* note_expr;
};

TraversalCode FindNoteCallback::PreExpr(const Expr* e)
	{
	if ( e->Tag() == EXPR_FIELD_ASSIGN )
		{
		const FieldAssignExpr* fae =
			dynamic_cast<const FieldAssignExpr*>(e);

		if ( ! streq(fae->FieldName(), "note") )
			return TC_CONTINUE;

		note_expr = fae->Op();
		return TC_ABORTALL;
		}

	return TC_CONTINUE;
	}


class NoticeCallback : public TraversalCallback {
public:
	virtual TraversalCode PreExpr(const Expr* e);

	PDict(cchar) notices;
};

TraversalCode NoticeCallback::PreExpr(const Expr* e)
	{
	if ( e->Tag() != EXPR_CALL )
		return TC_CONTINUE;

	const CallExpr* ce = dynamic_cast<const CallExpr*>(e);

	if ( ce->Func()->Tag() != EXPR_NAME ||
	     ! streq(((NameExpr*) ce->Func())->Id()->Name(), "NOTICE") )
		return TC_CONTINUE;

	FindNoteCallback fnc;
	ce->Traverse(&fnc);
	if ( fnc.note_expr )
		{
		ODesc d;
		fnc.note_expr->Describe(&d);
		if ( ! notices.Lookup(d.Description()) )
			{
			const char* desc = strdup(d.Description());
			notices.Insert(desc, desc);
			}
		}
	}


void notice_analysis()
	{
	NoticeCallback cb;
	traverse_all(&cb);

	const cchar* notice = 0;
	IterCookie* iter = cb.notices.InitForIteration();

	while ( (notice = cb.notices.NextEntry(iter)) )
		printf("Found NOTICE: %s\n", notice);
	}
