// $Id: SerialInfo.h,v 1.2 2005/02/09 08:19:03 vern Exp $
//
// Two helper classes to pass data between serialization methods.

#ifndef serialinfo_h
#define serialinfo_h

class SerialInfo {
public:
	SerialInfo(Serializer *arg_s)
		{
		s = arg_s;
		may_suspend = clear_containers = false;
		cache = true;
		type = SER_NONE;
		}

	SerialInfo(const SerialInfo& info)
		{
		s = info.s;
		may_suspend = info.may_suspend;
		cache = info.cache;
		type = info.type;
		clear_containers = info.clear_containers;
		}

	// Parameters that control serialization.
	Serializer* s;	// serializer to use
	bool cache;	// true if object caching is ok
	bool may_suspend;	// if true, suspending serialization is ok
	bool clear_containers;	// if true, store container values as emtpy

	// Attributes set during serialization.
	SerialType type;	// type of currently serialized object

	// State for suspending/resuming serialization
	Continuation cont;
};

class UnserialInfo {
public:
	UnserialInfo(Serializer* arg_s)
		{
		s = arg_s;
		cache = true;
		type = SER_NONE;
		install_globals = install_conns = true;
		ignore_callbacks = false;
		id_policy = Replace;
		print = 0;
		}

	UnserialInfo(const UnserialInfo& info)
		{
		s = info.s;
		cache = info.cache;
		type = info.type;
		install_globals = info.install_globals;
		install_conns = info.install_conns;
		ignore_callbacks = info.ignore_callbacks;
		id_policy = info.id_policy;
		print = info.print;
		}

	// Parameters that control unserialization.
	Serializer* s;	// serializer to use
	bool cache;	// if true,  object caching is ok
	FILE* print;	// print read objects to given file (human-readable)


	bool install_globals;	// if true, install unknown globals in global scope
	bool install_conns;	// if true, add connections to session table
	bool ignore_callbacks;	// if true, don't call Got*() callbacks

	// If a global ID already exits, of these policies is used.
	enum {
		Keep,	// keep the old ID and ignore the new
		Replace,	// install the new ID (default)

		// Keep current ID instance but copy the new value into it
		// (types have to match).
		CopyNewToCurrent,

		// Install the new ID instance but replace its value
		// with that of the old one (types have to match).
		CopyCurrentToNew,
	} id_policy;

	// Attributes set during unserialization.
	SerialType type;	// type of currently unserialized object
};

#endif
