// $Id: StateAccess.h,v 1.4 2005/09/02 23:00:06 vern Exp $
//
// A class describing a state-modyfing access to a Value or an ID.

#ifndef STATEACESSS_H
#define STATEACESSS_H

class Val;
class ID;
class MutableVal;
class HashKey;
class ODesc;
class Serializer;

enum Opcode {	// Op1	Op2 Op3 (Vals)
	OP_NONE,
	OP_ASSIGN,	// new	old
	OP_ASSIGN_IDX,	// new	old
	OP_ADD,		// idx  old
	OP_INCR,	// idx  new old
	OP_INCR_IDX,	// idx  new old
	OP_DEL,		// idx  old
	OP_PRINT,	// args
	OP_EXPIRE	// idx
};

class StateAccess : public SerialObj {
public:
	StateAccess(Opcode opcode, const ID* target, const Val* op1,
			const Val* op2 = 0, const Val* op3 = 0);
	StateAccess(Opcode opcode, const MutableVal* target, const Val* op1,
			const Val* op2 = 0, const Val* op3 = 0);

	// For tables, the idx operand may be given as an index HashKey.
	// This is for efficiency. While we need to reconstruct the index
	// if we are actually going to serialize the access, we can at
	// least skip it if we don't.
	StateAccess(Opcode opcode, const ID* target, const HashKey* op1,
			const Val* op2 = 0, const Val* op3 = 0);
	StateAccess(Opcode opcode, const MutableVal* target, const HashKey* op1,
			const Val* op2 = 0, const Val* op3 = 0);

	~StateAccess();

	// Replays this access in the our environment.
	void Replay();

	void Describe(ODesc* d) const;

	bool Serialize(SerialInfo* info) const;
	static StateAccess* Unserialize(UnserialInfo* info);

	// Main entry point when StateAcesses are performed.
	// For every state-changing operation, this has to be called.
	static void Log(StateAccess* access);

private:
	StateAccess()	{ target.id = 0; op1.val = op2 = op3 = 0; }
	StateAccess(const StateAccess& sa);
	void RefThem();

	bool CheckOld(const char* op, ID* id, Val* index, Val* should, Val* is);
	bool CheckOldSet(const char* op, ID* id, Val* index, bool should, bool is);

	DECLARE_SERIAL(StateAccess);

	Opcode opcode;
	union {
		ID* id;
		MutableVal* val;
	} target;

	union {
		Val* val;
		const HashKey* key;
	} op1;

	Val* op2;
	Val* op3;

	enum Type { TYPE_ID, TYPE_VAL, TYPE_MVAL, TYPE_KEY };
	Type target_type;
	Type op1_type;

	static bool replaying;
};

#endif
