// $Id: Telnet.cc,v 1.2 2005/03/12 08:11:29 vern Exp $
//
// Copyright (c) 1997, 1998, 1999, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "config.h"

#include "Telnet.h"
#include "NVT.h"

TelnetConn::TelnetConn(NetSessions* s, HashKey* k, double t, const ConnID* id,
		const struct tcphdr* tp)
: LoginConn(s, k, t, id, tp)
	{
	}

void TelnetConn::BuildEndpoints()
	{
	TCP_NVT* o_nvt = new TCP_NVT(orig, 0, 0, CR_as_EOL | LF_as_EOL);
	TCP_NVT* r_nvt = new TCP_NVT(resp, 0, 0, CR_as_EOL | LF_as_EOL);

	o_nvt->SetPeer(r_nvt);
	r_nvt->SetPeer(o_nvt);

	orig->AddContentsProcessor(o_nvt);
	resp->AddContentsProcessor(r_nvt);
	}
