// $Id: UDP.h,v 1.2 2004/11/02 07:28:32 vern Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef udp_h
#define udp_h

#include "Conn.h"

typedef enum {
	UDP_INACTIVE,	// no packet seen
	UDP_ACTIVE,	// packets seen
} UDP_EndpointState;

class UDP_Connection : public Connection {
public:
	UDP_Connection(NetSessions* s, HashKey* k, double t, const ConnID* id,
			const struct udphdr* up);

	void Done();

	void NextPacket(double t, int is_orig,
			const IP_Hdr* ip, int len, int caplen,
			const u_char*& data,
			int& record_packet, int& record_content,
			const struct pcap_pkthdr* hdr,
			const u_char* const pkt,
			int hdr_size);

	int IsReuse(double t, const u_char* pkt);

	TransportProto ConnTransport() const	{ return TRANSPORT_UDP; }

	void Describe(ODesc* d) const;

	unsigned int MemoryAllocation() const;

protected:
	UDP_Connection()	{ }

	virtual int Request(double t, const u_char* data, int len);
	virtual int Reply(double t, const u_char* data, int len);

	void UpdateEndpointVal(RecordVal* endp, int is_orig);

	DECLARE_SERIAL(UDP_Connection);

	int request_len, reply_len;
};

#endif
