// $Id: Var.h,v 1.2 2004/09/28 03:30:23 vern Exp $
//
// Copyright (c) 1995, 1996, 1997, 1998, 1999, 2001, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef var_h
#define var_h

#include "ID.h"
#include "Expr.h"
#include "Type.h"

class Func;
class EventHandlerPtr;

typedef enum { VAR_REGULAR, VAR_CONST, VAR_REDEF, } decl_type;

extern void add_global(ID* id, BroType* t, init_class c, Expr* init,
			attr_list* attr, decl_type dt);
extern Stmt* add_local(ID* id, BroType* t, init_class c, Expr* init,
			attr_list* attr, decl_type dt);

extern void add_type(ID* id, BroType* t, attr_list* attr, int is_event);

extern void begin_func(ID* id, const char* module_name, function_flavor flavor,
		       int is_redef, FuncType* t);
extern void end_func(Stmt* body);

extern Val* internal_val(const char* name);
extern Val* opt_internal_val(const char* name);	// returns nil if not defined
extern double opt_internal_double(const char* name);
extern int opt_internal_int(const char* name);
extern StringVal* opt_internal_string(const char* name);
extern TableVal* opt_internal_table(const char* name);	// nil if not defined
extern ListVal* internal_list_val(const char* name);
extern BroType* internal_type(const char* name);
extern Func* internal_func(const char* name);
extern EventHandlerPtr internal_handler(const char* name);

extern EventHandlerPtr bro_signal;
extern int signal_val;	// 0 if no signal pending

#endif
