// $Id: X509.h,v 1.1 2004/07/14 20:15:41 jason Exp $

#ifndef X509_H
#define X509_H

#include <sys/types.h>
#include <openssl/x509.h>
#include <openssl/x509_vfy.h>

#include "SSLProxy.h"

class X509_Cert {
public:
	static X509_STORE* ctx;
	static X509_LOOKUP* lookup;
	static X509_STORE_CTX csc;
	static bool bInited;

	// Initializes the OpenSSL library, which is used for verify().
	static int init();

	// Wrapper for X.509 error event.
	static void sslCertificateError(SSL_ProxyEndpoint* e, int error_numbe);

	// Retrieves a DER-encoded X.509 certificate.  Returns 0 on failure.
	static int verify(SSL_ProxyEndpoint* e, u_char* data, uint32 len);
	static int verifyChain(SSL_ProxyEndpoint* e, u_char* data, uint32 len);

	// Wrapper for the ssl_certificate event.
	static void sslCertificateEvent(SSL_ProxyEndpoint* e, X509* pCert);
};

#endif
