// $Id: XDR.cc,v 1.2 2005/04/21 07:01:54 vern Exp $
//
// Copyright (c) 1996, 1997, 1998, 1999, 2002
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "config.h"

#include "XDR.h"

uint32 extract_XDR_uint32(const u_char*& buf, int& len)
	{
	if ( ! buf )
		return 0;

	if ( len < 4 )
		{
		buf = 0;
		return 0;
		}

	uint32 bits32 = XDR_aligned(buf) ? *(uint32*) buf :
		((buf[0] << 24) | (buf[1] << 16) | (buf[2] << 8) | buf[3]);

	buf += 4;
	len -= 4;

	return ntohl(bits32);
	}

double extract_XDR_uint64_as_double(const u_char*& buf, int& len)
	{
	if ( ! buf || len < 8 )
		{
		buf = 0;
		return 0.0;
		}

	uint32 uhi = extract_XDR_uint32(buf, len);
	uint32 ulo = extract_XDR_uint32(buf, len);

	return double(uhi) * 4294967296.0 + double(ulo);
	}

double extract_XDR_time(const u_char*& buf, int& len)
	{
	if ( ! buf || len < 8 )
		{
		buf = 0;
		return 0.0;
		}

	uint32 uhi = extract_XDR_uint32(buf, len);
	uint32 ulo = extract_XDR_uint32(buf, len);

	return double(uhi) + double(ulo) / 1e9;
	}

const u_char* extract_XDR_opaque(const u_char*& buf, int& len, int& n, int max_len)
	{
	n = int(extract_XDR_uint32(buf, len));
	if ( ! buf )
		return 0;

	if ( n < 0 || n > len || n > max_len )
		{ // ### Should really flag this as a different sort of error.
		buf = 0;
		return 0;
		}

	int n4 = ((n + 3) >> 2) << 2;	// n rounded up to next multiple of 4

	len -= n4;
	const u_char* opaque = buf;
	buf += n4;

	return opaque;
	}

uint32 skip_XDR_opaque_auth(const u_char*& buf, int& len)
	{
	uint32 auth_flavor = extract_XDR_uint32(buf, len);
	if ( ! buf )
		return 0;

	int n;
	(void) extract_XDR_opaque(buf, len, n, 400);

	return auth_flavor;
	}
