// $Id: bif_arg.cc,v 1.2 2005/06/09 17:46:16 jason Exp $

#include "config.h"

#include <string.h>

#include "bif_arg.h"

static struct {
	const char* bif_type;
	const char* bro_type;
	const char* c_type;
	const char* accessor;
} builtin_func_arg_type[] = {
#define DEFINE_BIF_TYPE(id, bif_type, bro_type, c_type, accessor) {bif_type, bro_type, c_type, accessor},
#include "bif_type.def"
#undef DEFINE_BIF_TYPE
};

extern const char* arg_list_name;

BuiltinFuncArg::BuiltinFuncArg(const char* arg_name, int arg_type)
	{
	name = arg_name;
	type = arg_type;
	type_str = "";
	}

BuiltinFuncArg::BuiltinFuncArg(const char* arg_name, const char* arg_type_str)
	{
	name = arg_name;
	type = TYPE_OTHER;
	type_str = arg_type_str;

	for ( int i = 0; builtin_func_arg_type[i].bif_type[0] != '\0'; ++i )
		if ( ! strcmp(builtin_func_arg_type[i].bif_type, arg_type_str) )
			{
			type = i;
			type_str = "";
			}
	}

void BuiltinFuncArg::PrintBro(FILE* fp)
	{
	fprintf(fp, "%s: %s%s", name, builtin_func_arg_type[type].bro_type, type_str);
	}

void BuiltinFuncArg::PrintCDef(FILE* fp, int n)
	{
	fprintf(fp,
		"\t%s %s = (%s) ((*%s)[%d]%s);\n",
		builtin_func_arg_type[type].c_type,
		name,
		builtin_func_arg_type[type].c_type,
		arg_list_name,
		n,
		builtin_func_arg_type[type].accessor);
	}
